/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.DataType;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableImpl
extends CDLTypeImpl
implements Variable {
    public static final String INFORMATIONTYPE = "informationType";
    public static final String CHANNELTYPE = "channelType";
    public static final String SILENT = "silent";
    public static final String FREE = "free";
    public static final String MUTABLE = "mutable";
    public static final String ROLETYPES = "roleTypes";
    public static final String NAME = "name";
    public static final String VARIABLE_TAGNAME = "variable";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected DataType type;
    protected static final Boolean MUTABLE_EDEFAULT = Boolean.TRUE;
    protected Boolean mutable = MUTABLE_EDEFAULT;
    protected static final Boolean FREE_EDEFAULT = Boolean.FALSE;
    protected Boolean free = FREE_EDEFAULT;
    protected static final Boolean SILENT_EDEFAULT = Boolean.FALSE;
    protected Boolean silent = SILENT_EDEFAULT;
    protected EList<RoleType> roleTypes;

    @Override
    public RoleType[] getRoleTypesForContext() {
        Object[] ret = null;
        if (this.getRoleTypes().size() > 0) {
            ret = new RoleType[this.getRoleTypes().size()];
            this.getRoleTypes().toArray(ret);
        } else {
            ret = super.getRoleTypesForContext();
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        ret = this.getRoleTypes().contains((Object)roleType) ? true : this.isRoleTypeAssociatedWithContext(roleType.getName());
        return ret;
    }

    @Override
    protected String getExportTagname() {
        return VARIABLE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        String tag;
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if ((tag = this.getTypeClassificationTag()) != null) {
            elem.setAttribute(tag, VariableImpl.addTNS(this.getType().getName()));
        }
        if (this.getRoleTypes().size() > 0) {
            String types = "";
            int i = 0;
            while (i < this.getRoleTypes().size()) {
                RoleType rt = (RoleType)this.getRoleTypes().get(i);
                if (this.isSet(rt.getName())) {
                    if (types.length() > 0) {
                        types = String.valueOf(types) + " ";
                    }
                    types = String.valueOf(types) + VariableImpl.addTNS(rt.getName());
                }
                ++i;
            }
            if (types.length() > 0) {
                elem.setAttribute(ROLETYPES, types);
            }
        }
        if (!this.isSet(this.getMutable(), true)) {
            elem.setAttribute(MUTABLE, this.getMutable().toString());
        }
        if (this.isSet(this.getFree(), false)) {
            elem.setAttribute(FREE, this.getFree().toString());
        }
        if (this.isSet(this.getSilent(), false)) {
            elem.setAttribute(SILENT, this.getSilent().toString());
        }
        return elem;
    }

    protected String getTypeClassificationTag() {
        String ret = null;
        if (this.getType() != null) {
            switch (this.getType().getClassification()) {
                case 2: {
                    ret = CHANNELTYPE;
                    break;
                }
                default: {
                    ret = INFORMATIONTYPE;
                }
            }
        }
        return ret;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(VARIABLE_TAGNAME)) {
            String type;
            this.setName(elem.getAttribute(NAME));
            Package cdlpack = this.getPackage();
            if (elem.hasAttribute(INFORMATIONTYPE)) {
                type = elem.getAttribute(INFORMATIONTYPE);
                if (cdlpack != null) {
                    InformationType infoType = cdlpack.getInformationType(type);
                    if (infoType != null) {
                        this.setType(infoType);
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_INFO_TYPE", new Object[]{type}), 2);
                    }
                }
            } else if (elem.hasAttribute(CHANNELTYPE)) {
                type = elem.getAttribute(CHANNELTYPE);
                if (cdlpack != null) {
                    ChannelType channelType = cdlpack.getChannelType(type);
                    if (channelType != null) {
                        this.setType(channelType);
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_CHANNEL_TYPE", new Object[]{type}), 2);
                    }
                }
            }
            this.setMutable(this.importBoolean(elem.getAttribute(MUTABLE), true));
            this.setFree(this.importBoolean(elem.getAttribute(FREE), false));
            this.setSilent(this.importBoolean(elem.getAttribute(SILENT), false));
            String roleTypes = elem.getAttribute(ROLETYPES);
            if (this.isSet(roleTypes) && cdlpack != null) {
                StringTokenizer st = new StringTokenizer(roleTypes, " ");
                while (st.hasMoreTokens()) {
                    String roleTypeName = st.nextToken();
                    RoleType roleType = cdlpack.getRoleType(roleTypeName);
                    if (roleType == null) {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{roleTypeName}), 2);
                        continue;
                    }
                    this.getRoleTypes().add((Object)roleType);
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Choreography choreo = this.getEnclosingChoreography();
        if (choreo != null && this.isSet(this.getName()) && choreo.getVariable(this.getName()) != this) {
            l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
        }
    }

    protected VariableImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.VARIABLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public DataType getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (DataType)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public DataType basicGetType() {
        return this.type;
    }

    @Override
    public void setType(DataType newType) {
        DataType oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public Boolean getMutable() {
        return this.mutable;
    }

    @Override
    public void setMutable(Boolean newMutable) {
        Boolean oldMutable = this.mutable;
        this.mutable = newMutable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldMutable, (Object)this.mutable));
        }
    }

    @Override
    public Boolean getFree() {
        return this.free;
    }

    @Override
    public void setFree(Boolean newFree) {
        Boolean oldFree = this.free;
        this.free = newFree;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFree, (Object)this.free));
        }
    }

    @Override
    public Boolean getSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(Boolean newSilent) {
        Boolean oldSilent = this.silent;
        this.silent = newSilent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldSilent, (Object)this.silent));
        }
    }

    @Override
    public EList<RoleType> getRoleTypes() {
        if (this.roleTypes == null) {
            this.roleTypes = new EObjectResolvingEList(RoleType.class, (InternalEObject)this, 7);
        }
        return this.roleTypes;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 4: {
                return this.getMutable();
            }
            case 5: {
                return this.getFree();
            }
            case 6: {
                return this.getSilent();
            }
            case 7: {
                return this.getRoleTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setType((DataType)newValue);
                return;
            }
            case 4: {
                this.setMutable((Boolean)newValue);
                return;
            }
            case 5: {
                this.setFree((Boolean)newValue);
                return;
            }
            case 6: {
                this.setSilent((Boolean)newValue);
                return;
            }
            case 7: {
                this.getRoleTypes().clear();
                this.getRoleTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setType(null);
                return;
            }
            case 4: {
                this.setMutable(MUTABLE_EDEFAULT);
                return;
            }
            case 5: {
                this.setFree(FREE_EDEFAULT);
                return;
            }
            case 6: {
                this.setSilent(SILENT_EDEFAULT);
                return;
            }
            case 7: {
                this.getRoleTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.type != null;
            }
            case 4: {
                return MUTABLE_EDEFAULT == null ? this.mutable != null : !MUTABLE_EDEFAULT.equals(this.mutable);
            }
            case 5: {
                return FREE_EDEFAULT == null ? this.free != null : !FREE_EDEFAULT.equals(this.free);
            }
            case 6: {
                return SILENT_EDEFAULT == null ? this.silent != null : !SILENT_EDEFAULT.equals(this.silent);
            }
            case 7: {
                return this.roleTypes != null && !this.roleTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", mutable: ");
        result.append(this.mutable);
        result.append(", free: ");
        result.append(this.free);
        result.append(", silent: ");
        result.append(this.silent);
        result.append(')');
        return result.toString();
    }
}

