/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RelationshipType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTypeImpl
extends CDLTypeImpl
implements RelationshipType {
    public static final String BEHAVIOR = "behavior";
    public static final String TYPEREF = "typeRef";
    public static final String ROLETYPE = "roleType";
    public static final String NAME = "name";
    public static final String RELATIONSHIPTYPE_TAGNAME = "relationshipType";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected RoleType firstRoleType;
    protected EList<Behavior> firstRoleTypeBehaviors;
    protected RoleType secondRoleType;
    protected EList<Behavior> secondRoleTypeBehaviors;

    @Override
    protected String getExportTagname() {
        return RELATIONSHIPTYPE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        Element first = this.createCDLElement(elem, ROLETYPE);
        if (this.getFirstRoleType() != null) {
            first.setAttribute(TYPEREF, RelationshipTypeImpl.addTNS(this.getFirstRoleType().getName()));
            String behaviors = "";
            for (Behavior behavior : this.getFirstRoleTypeBehaviors()) {
                if (behaviors.length() > 0) {
                    behaviors = String.valueOf(behaviors) + " ";
                }
                behaviors = String.valueOf(behaviors) + behavior.getName();
            }
            if (behaviors.length() > 0) {
                first.setAttribute(BEHAVIOR, behaviors);
            }
        }
        elem.appendChild(first);
        Element second = this.createCDLElement(elem, ROLETYPE);
        if (this.getSecondRoleType() != null) {
            second.setAttribute(TYPEREF, RelationshipTypeImpl.addTNS(this.getSecondRoleType().getName()));
            String behaviors = "";
            for (Behavior behavior : this.getSecondRoleTypeBehaviors()) {
                if (behaviors.length() > 0) {
                    behaviors = String.valueOf(behaviors) + " ";
                }
                behaviors = String.valueOf(behaviors) + behavior.getName();
            }
            if (behaviors.length() > 0) {
                second.setAttribute(BEHAVIOR, behaviors);
            }
        }
        elem.appendChild(second);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(RELATIONSHIPTYPE_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
            Element firstRole = null;
            Element secondRole = null;
            NodeList nl = elem.getChildNodes();
            int i = 0;
            while ((firstRole == null || secondRole == null) && i < nl.getLength()) {
                if (nl.item(i) instanceof Element && nl.item(i).getNodeName().equals(ROLETYPE)) {
                    if (firstRole == null) {
                        firstRole = (Element)nl.item(i);
                    } else if (secondRole == null) {
                        secondRole = (Element)nl.item(i);
                    }
                }
                ++i;
            }
            if (firstRole != null && secondRole != null) {
                this.setFirstRoleType(this.findRole(firstRole, l));
                if (this.getFirstRoleType() != null) {
                    this.findBehaviors(this.getFirstRoleType(), firstRole, (List)this.getFirstRoleTypeBehaviors(), l);
                }
                this.setSecondRoleType(this.findRole(secondRole, l));
                if (this.getSecondRoleType() != null) {
                    this.findBehaviors(this.getSecondRoleType(), secondRole, (List)this.getSecondRoleTypeBehaviors(), l);
                }
            } else {
                l.report((Object)this, this.getMessage("_REL_TWO_ROLES", new Object[]{this.getName()}), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    protected RoleType findRole(Element roleelem, ModelListener l) {
        RoleType ret = null;
        String type = roleelem.getAttribute(TYPEREF);
        Package cdlpack = this.getPackage();
        if (cdlpack != null && (ret = cdlpack.getRoleType(type)) == null) {
            l.report((Object)this, this.getMessage("_NOT_FOUND_REL_ROLE_TYPE", new Object[]{this.getName(), type}), 2);
        }
        return ret;
    }

    protected void findBehaviors(RoleType role, Element roleelem, List list, ModelListener l) {
        String behaviors = roleelem.getAttribute(BEHAVIOR);
        if (this.isSet(behaviors)) {
            StringTokenizer st = new StringTokenizer(behaviors, " ");
            while (st.hasMoreTokens()) {
                String behaviorName = st.nextToken();
                Behavior behavior = role.getBehavior(behaviorName);
                if (behavior != null) {
                    list.add(behavior);
                    continue;
                }
                l.report((Object)this, this.getMessage("_NOT_FOUND_BEHAVIOR_ON_ROLE_TYPE", new Object[]{behaviorName, role.getName()}), 2);
            }
        }
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Package cdlpack = this.getPackage();
        if (cdlpack != null && this.isSet(this.getName()) && cdlpack.getRelationshipType(this.getName()) != this) {
            l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
        }
    }

    @Override
    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<RoleType> ret = new Vector<RoleType>();
        if (this.getFirstRoleType() != null) {
            ret.add(this.getFirstRoleType());
        }
        if (this.getSecondRoleType() != null) {
            ret.add(this.getFirstRoleType());
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (this.getFirstRoleType() != null && roleType != null) {
            ret = this.getFirstRoleType().equals(roleType);
        }
        if (!ret && this.getSecondRoleType() != null && roleType != null) {
            ret = this.getSecondRoleType().equals(roleType);
        }
        return ret;
    }

    protected RelationshipTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.RELATIONSHIP_TYPE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public RoleType getFirstRoleType() {
        if (this.firstRoleType != null && this.firstRoleType.eIsProxy()) {
            InternalEObject oldFirstRoleType = (InternalEObject)this.firstRoleType;
            this.firstRoleType = (RoleType)this.eResolveProxy(oldFirstRoleType);
            if (this.firstRoleType != oldFirstRoleType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldFirstRoleType, (Object)this.firstRoleType));
            }
        }
        return this.firstRoleType;
    }

    public RoleType basicGetFirstRoleType() {
        return this.firstRoleType;
    }

    @Override
    public void setFirstRoleType(RoleType newFirstRoleType) {
        RoleType oldFirstRoleType = this.firstRoleType;
        this.firstRoleType = newFirstRoleType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldFirstRoleType, (Object)this.firstRoleType));
        }
    }

    @Override
    public EList<Behavior> getFirstRoleTypeBehaviors() {
        if (this.firstRoleTypeBehaviors == null) {
            this.firstRoleTypeBehaviors = new EObjectResolvingEList(Behavior.class, (InternalEObject)this, 4);
        }
        return this.firstRoleTypeBehaviors;
    }

    @Override
    public RoleType getSecondRoleType() {
        if (this.secondRoleType != null && this.secondRoleType.eIsProxy()) {
            InternalEObject oldSecondRoleType = (InternalEObject)this.secondRoleType;
            this.secondRoleType = (RoleType)this.eResolveProxy(oldSecondRoleType);
            if (this.secondRoleType != oldSecondRoleType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldSecondRoleType, (Object)this.secondRoleType));
            }
        }
        return this.secondRoleType;
    }

    public RoleType basicGetSecondRoleType() {
        return this.secondRoleType;
    }

    @Override
    public void setSecondRoleType(RoleType newSecondRoleType) {
        RoleType oldSecondRoleType = this.secondRoleType;
        this.secondRoleType = newSecondRoleType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSecondRoleType, (Object)this.secondRoleType));
        }
    }

    @Override
    public EList<Behavior> getSecondRoleTypeBehaviors() {
        if (this.secondRoleTypeBehaviors == null) {
            this.secondRoleTypeBehaviors = new EObjectResolvingEList(Behavior.class, (InternalEObject)this, 6);
        }
        return this.secondRoleTypeBehaviors;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getFirstRoleType();
                }
                return this.basicGetFirstRoleType();
            }
            case 4: {
                return this.getFirstRoleTypeBehaviors();
            }
            case 5: {
                if (resolve) {
                    return this.getSecondRoleType();
                }
                return this.basicGetSecondRoleType();
            }
            case 6: {
                return this.getSecondRoleTypeBehaviors();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setFirstRoleType((RoleType)newValue);
                return;
            }
            case 4: {
                this.getFirstRoleTypeBehaviors().clear();
                this.getFirstRoleTypeBehaviors().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setSecondRoleType((RoleType)newValue);
                return;
            }
            case 6: {
                this.getSecondRoleTypeBehaviors().clear();
                this.getSecondRoleTypeBehaviors().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setFirstRoleType(null);
                return;
            }
            case 4: {
                this.getFirstRoleTypeBehaviors().clear();
                return;
            }
            case 5: {
                this.setSecondRoleType(null);
                return;
            }
            case 6: {
                this.getSecondRoleTypeBehaviors().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.firstRoleType != null;
            }
            case 4: {
                return this.firstRoleTypeBehaviors != null && !this.firstRoleTypeBehaviors.isEmpty();
            }
            case 5: {
                return this.secondRoleType != null;
            }
            case 6: {
                return this.secondRoleTypeBehaviors != null && !this.secondRoleTypeBehaviors.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

