/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.BindDetails;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantBindDetails;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.ActivityImpl;
import org.pi4soa.cdl.impl.ChoreographyImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformImpl
extends ActivityImpl
implements Perform {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.impl");
    public static final String PERFORM_TAGNAME = "perform";
    public static final String CHOREOGRAPHYINSTANCEID = "choreographyInstanceId";
    public static final String CHOREOGRAPHYNAME = "choreographyName";
    public static final String BLOCK = "block";
    private String m_importedChoreographyName = null;
    private boolean m_aggregatingVisibleRoleTypes = false;
    private boolean m_isRelevantRoleTypesGuard = false;
    protected EList<BindDetails> bindDetails;
    protected static final String CHOREOGRAPHY_INSTANCE_ID_EDEFAULT = null;
    protected String choreographyInstanceId = CHOREOGRAPHY_INSTANCE_ID_EDEFAULT;
    protected Choreography choreography;
    protected static final Boolean WAIT_FOR_COMPLETION_EDEFAULT = Boolean.TRUE;
    protected Boolean waitForCompletion = WAIT_FOR_COMPLETION_EDEFAULT;
    protected EList<ParticipantBindDetails> participantBindDetails;

    @Override
    protected String getExportTagname() {
        return PERFORM_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getChoreography() != null) {
            elem.setAttribute(CHOREOGRAPHYNAME, PerformImpl.addTNS(this.getChoreography().getName()));
        }
        if (this.isSet(this.getChoreographyInstanceId())) {
            elem.setAttribute(CHOREOGRAPHYINSTANCEID, this.getChoreographyInstanceId());
        }
        if (!this.isSet(this.getWaitForCompletion(), true)) {
            elem.setAttribute(BLOCK, Boolean.FALSE.toString());
        }
        if (this.getBindDetails() != null && this.getBindDetails().size() > 0) {
            this.exportListAsDOMElements((List)this.getBindDetails(), elem, l, context);
        }
        if (context.isVersionSupported(2) && this.getParticipantBindDetails() != null && this.getParticipantBindDetails().size() > 0) {
            this.exportListAsDOMElements((List)this.getParticipantBindDetails(), elem, l, context);
        }
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(PERFORM_TAGNAME)) {
            this.m_importedChoreographyName = elem.getAttribute(CHOREOGRAPHYNAME);
            if (elem.hasAttribute(CHOREOGRAPHYINSTANCEID)) {
                this.setChoreographyInstanceId(elem.getAttribute(CHOREOGRAPHYINSTANCEID));
            }
            if (elem.hasAttribute(BLOCK)) {
                this.setWaitForCompletion(this.importBoolean(elem.getAttribute(BLOCK), true));
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    public void initialize(ModelListener l) {
        if (this.isSet(this.m_importedChoreographyName)) {
            Package cdlpack;
            Choreography choreo = null;
            Choreography thisChoreo = this.getEnclosingChoreography();
            if (thisChoreo != null) {
                choreo = thisChoreo.getEnclosedChoreography(this.m_importedChoreographyName);
            }
            if (choreo == null && (cdlpack = this.getPackage()) != null) {
                choreo = cdlpack.getChoreography(this.m_importedChoreographyName);
            }
            if (choreo == null) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_CHOREOGRAPHY", new Object[]{this.m_importedChoreographyName}), 2);
            } else {
                this.setChoreography(choreo);
            }
        }
        super.initialize(l);
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        CDLType ret = null;
        String name = elem.getLocalName();
        if (elem.getNamespaceURI() != null) {
            if (elem.getNamespaceURI().equals("http://www.w3.org/2005/10/cdl")) {
                if (name.equals("bind")) {
                    ret = CdlFactory.eINSTANCE.createBindDetails();
                    this.getBindDetails().add((Object)ret);
                } else if (name.equals("choreography")) {
                    ret = CdlFactory.eINSTANCE.createChoreography();
                    Choreography choreo = this.getEnclosingChoreography();
                    if (choreo != null) {
                        choreo.getEnclosedChoreographies().add((Object)((Choreography)ret));
                    }
                }
            } else if (elem.getNamespaceURI().equals("http://www.pi4soa.org/cdl2") && name.equals("participantBinding")) {
                ret = CdlFactory.eINSTANCE.createParticipantBindDetails();
                this.getParticipantBindDetails().add((Object)((ParticipantBindDetails)ret));
            }
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.getChoreography() != null) {
            if (this.getChoreography().eContainer() != this.getEnclosingChoreography() && !(this.getChoreography().eContainer() instanceof Package)) {
                l.report((Object)this, this.getMessage("_PERFORMED_CHOREO_SCOPE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"choreography"));
            }
            if (this.isSet(this.getChoreography().getRoot(), false)) {
                l.report((Object)this, this.getMessage("_NOT_PERFORM_ROOT_CHOREO", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"choreography"));
            }
            if (this.isSet(this.getChoreographyInstanceId())) {
                String label = this.getMessage("_CHOREO_INSTANCE_ID", null);
                XPathContext xpcontext = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, label, false);
                XPathValidator.validateExpression(xpcontext, this.getChoreographyInstanceId(), this.getRoleTypesForContext(), null, true);
            }
            this.validateFreeVariables(l);
            this.validateFreeParticipants(l);
        }
    }

    protected void validateFreeVariables(ModelListener l) throws ValidationException {
        for (Variable var : this.getChoreography().getVariableDefinitions()) {
            if (var.getFree() != Boolean.TRUE) continue;
            RoleType[] varRoleTypes = var.getRoleTypesForContext();
            int i = 0;
            while (i < varRoleTypes.length) {
                if (this.getChoreography().isRelevantToRoleType(varRoleTypes[i])) {
                    BindDetails bind = null;
                    Iterator binds = this.getBindDetails().iterator();
                    while (bind == null && binds.hasNext()) {
                        bind = (BindDetails)binds.next();
                        if (bind.getFreeVariable() == var) {
                            if (bind.getFreeRole() == null || PackageUtil.getParticipantForRoleType(bind.getFreeRole()) == PackageUtil.getParticipantForRoleType(varRoleTypes[i])) continue;
                            bind = null;
                            continue;
                        }
                        bind = null;
                    }
                    if (bind == null) {
                        l.report((Object)this, this.getMessage("_FREE_VARIABLE_NOT_BOUND", new Object[]{var.getName(), varRoleTypes[i].getName()}), 2);
                    }
                }
                ++i;
            }
        }
    }

    protected void validateFreeParticipants(ModelListener l) throws ValidationException {
        for (Participant part : this.getChoreography().getParticipantDefinitions()) {
            if (part.getFree() != Boolean.TRUE) continue;
            Iterator binds = this.getParticipantBindDetails().iterator();
            ParticipantBindDetails bind = null;
            while (bind == null && binds.hasNext()) {
                bind = (ParticipantBindDetails)binds.next();
                if (bind.getFreeParticipant() == part) continue;
                bind = null;
            }
            if (bind != null) continue;
            l.report((Object)this, this.getMessage("_FREE_PARTICIPANT_NOT_BOUND", new Object[]{part.getName()}), 2);
        }
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.perform(this);
        super.visit(visitor);
    }

    @Override
    protected synchronized Vector getAggregatedVisibleRoleTypes() {
        Vector ret = null;
        if (!this.m_aggregatingVisibleRoleTypes && this.getChoreography() instanceof ChoreographyImpl) {
            try {
                try {
                    this.m_aggregatingVisibleRoleTypes = true;
                    ret = ((ChoreographyImpl)this.getChoreography()).getAggregatedVisibleRoleTypes();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to get aggregated visible role types: " + t, t);
                    this.m_aggregatingVisibleRoleTypes = false;
                }
            }
            finally {
                this.m_aggregatingVisibleRoleTypes = false;
            }
        } else {
            ret = new Vector();
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_isRelevantRoleTypesGuard && this.getChoreography() instanceof ChoreographyImpl) {
            try {
                try {
                    this.m_isRelevantRoleTypesGuard = true;
                    ret = ((ChoreographyImpl)this.getChoreography()).isRelevantToRoleType(roleType);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to check is relevant role type: " + t, t);
                    this.m_isRelevantRoleTypesGuard = false;
                }
            }
            finally {
                this.m_isRelevantRoleTypesGuard = false;
            }
        }
        return ret;
    }

    @Override
    public String getName() {
        String ret = null;
        if (this.getChoreography() != null) {
            ret = this.getChoreography().getName();
        }
        return ret;
    }

    protected PerformImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.PERFORM;
    }

    @Override
    public EList<BindDetails> getBindDetails() {
        if (this.bindDetails == null) {
            this.bindDetails = new EObjectContainmentEList(BindDetails.class, (InternalEObject)this, 2);
        }
        return this.bindDetails;
    }

    @Override
    public String getChoreographyInstanceId() {
        return this.choreographyInstanceId;
    }

    @Override
    public void setChoreographyInstanceId(String newChoreographyInstanceId) {
        String oldChoreographyInstanceId = this.choreographyInstanceId;
        this.choreographyInstanceId = newChoreographyInstanceId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldChoreographyInstanceId, (Object)this.choreographyInstanceId));
        }
    }

    @Override
    public Choreography getChoreography() {
        if (this.choreography != null && this.choreography.eIsProxy()) {
            InternalEObject oldChoreography = (InternalEObject)this.choreography;
            this.choreography = (Choreography)this.eResolveProxy(oldChoreography);
            if (this.choreography != oldChoreography && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldChoreography, (Object)this.choreography));
            }
        }
        return this.choreography;
    }

    public Choreography basicGetChoreography() {
        return this.choreography;
    }

    @Override
    public void setChoreography(Choreography newChoreography) {
        Choreography oldChoreography = this.choreography;
        this.choreography = newChoreography;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldChoreography, (Object)this.choreography));
        }
    }

    @Override
    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void setWaitForCompletion(Boolean newWaitForCompletion) {
        Boolean oldWaitForCompletion = this.waitForCompletion;
        this.waitForCompletion = newWaitForCompletion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldWaitForCompletion, (Object)this.waitForCompletion));
        }
    }

    @Override
    public EList<ParticipantBindDetails> getParticipantBindDetails() {
        if (this.participantBindDetails == null) {
            this.participantBindDetails = new EObjectContainmentEList(ParticipantBindDetails.class, (InternalEObject)this, 6);
        }
        return this.participantBindDetails;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getBindDetails()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getParticipantBindDetails()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getBindDetails();
            }
            case 3: {
                return this.getChoreographyInstanceId();
            }
            case 4: {
                if (resolve) {
                    return this.getChoreography();
                }
                return this.basicGetChoreography();
            }
            case 5: {
                return this.getWaitForCompletion();
            }
            case 6: {
                return this.getParticipantBindDetails();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getBindDetails().clear();
                this.getBindDetails().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setChoreographyInstanceId((String)newValue);
                return;
            }
            case 4: {
                this.setChoreography((Choreography)newValue);
                return;
            }
            case 5: {
                this.setWaitForCompletion((Boolean)newValue);
                return;
            }
            case 6: {
                this.getParticipantBindDetails().clear();
                this.getParticipantBindDetails().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getBindDetails().clear();
                return;
            }
            case 3: {
                this.setChoreographyInstanceId(CHOREOGRAPHY_INSTANCE_ID_EDEFAULT);
                return;
            }
            case 4: {
                this.setChoreography(null);
                return;
            }
            case 5: {
                this.setWaitForCompletion(WAIT_FOR_COMPLETION_EDEFAULT);
                return;
            }
            case 6: {
                this.getParticipantBindDetails().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.bindDetails != null && !this.bindDetails.isEmpty();
            }
            case 3: {
                return CHOREOGRAPHY_INSTANCE_ID_EDEFAULT == null ? this.choreographyInstanceId != null : !CHOREOGRAPHY_INSTANCE_ID_EDEFAULT.equals(this.choreographyInstanceId);
            }
            case 4: {
                return this.choreography != null;
            }
            case 5: {
                return WAIT_FOR_COMPLETION_EDEFAULT == null ? this.waitForCompletion != null : !WAIT_FOR_COMPLETION_EDEFAULT.equals(this.waitForCompletion);
            }
            case 6: {
                return this.participantBindDetails != null && !this.participantBindDetails.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (choreographyInstanceId: ");
        result.append(this.choreographyInstanceId);
        result.append(", waitForCompletion: ");
        result.append(this.waitForCompletion);
        result.append(')');
        return result.toString();
    }
}

