/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantImpl
extends CDLTypeImpl
implements Participant {
    public static final String FREE = "free";
    public static final String ROLETYPES = "roleTypes";
    public static final String NAME = "name";
    public static final String PARTICIPANT_TAGNAME = "participant";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<RoleType> roleTypes;
    protected static final Boolean FREE_EDEFAULT = Boolean.FALSE;
    protected Boolean free = FREE_EDEFAULT;

    @Override
    public RoleType[] getRoleTypesForContext() {
        Object[] ret = null;
        if (this.getRoleTypes().size() > 0) {
            ret = new RoleType[this.getRoleTypes().size()];
            this.getRoleTypes().toArray(ret);
        } else {
            ret = super.getRoleTypesForContext();
        }
        return ret;
    }

    public boolean isRelevantToRoleType(String roleType) {
        boolean ret = this.isRoleTypeAssociatedWithContext(roleType);
        return ret;
    }

    @Override
    public boolean isRelevantToRoleTypes(RoleType[] roleTypes) {
        boolean ret = this.getRoleTypes().size() > 0;
        Iterator iter = this.getRoleTypes().iterator();
        while (roleTypes != null && ret && iter.hasNext()) {
            RoleType rt = (RoleType)iter.next();
            boolean f_found = false;
            int i = 0;
            while (!f_found && i < roleTypes.length) {
                if (rt == roleTypes[i]) {
                    f_found = true;
                }
                ++i;
            }
            if (f_found) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    protected String getExportTagname() {
        return "cdl2:participant";
    }

    @Override
    protected String getExportNamespace() {
        return "http://www.pi4soa.org/cdl2";
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute("cdl2:name", this.getName());
        }
        if (this.getRoleTypes().size() > 0) {
            String types = "";
            int i = 0;
            while (i < this.getRoleTypes().size()) {
                RoleType rt = (RoleType)this.getRoleTypes().get(i);
                if (this.isSet(rt.getName())) {
                    if (types.length() > 0) {
                        types = String.valueOf(types) + " ";
                    }
                    types = String.valueOf(types) + ParticipantImpl.addTNS(rt.getName());
                }
                ++i;
            }
            if (types.length() > 0) {
                elem.setAttribute("cdl2:roleTypes", types);
            }
        }
        if (this.isSet(this.getFree(), false)) {
            elem.setAttribute("cdl2:free", this.getFree().toString());
        }
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getLocalName().equals(PARTICIPANT_TAGNAME)) {
            this.setName(elem.getAttributeNS("http://www.pi4soa.org/cdl2", NAME));
            Package cdlpack = this.getPackage();
            this.setFree(this.importBoolean(elem.getAttributeNS("http://www.pi4soa.org/cdl2", FREE), false));
            String roleTypes = elem.getAttributeNS("http://www.pi4soa.org/cdl2", ROLETYPES);
            if (this.isSet(roleTypes) && cdlpack != null) {
                StringTokenizer st = new StringTokenizer(roleTypes, " ");
                while (st.hasMoreTokens()) {
                    String roleTypeName = st.nextToken();
                    RoleType roleType = cdlpack.getRoleType(roleTypeName);
                    if (roleType == null) {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{roleTypeName}), 2);
                        continue;
                    }
                    this.getRoleTypes().add((Object)roleType);
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (context.isVersionSupported(2)) {
            Package cdlpack = this.getPackage();
            if (cdlpack != null && this.isSet(this.getName()) && this.getFree() == Boolean.FALSE) {
                List list = cdlpack.getParticipants();
                boolean f_unique = true;
                int i = 0;
                while (f_unique && i < list.size()) {
                    Participant part = (Participant)list.get(i);
                    if (part != this && this.getName().equals(part.getName()) && part.getFree() == Boolean.FALSE) {
                        f_unique = false;
                    }
                    ++i;
                }
                if (!f_unique) {
                    l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
                }
            }
            if (this.getRoleTypes().size() == 0) {
                l.report((Object)this, this.getMessage("_TOO_FEW_REFERENCES", new Object[]{ROLETYPES, "1", "RoleType"}), 2, ValidationDefinitions.getPropertyNameInfo((String)ROLETYPES));
            }
        }
    }

    protected ParticipantImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.PARTICIPANT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<RoleType> getRoleTypes() {
        if (this.roleTypes == null) {
            this.roleTypes = new EObjectResolvingEList(RoleType.class, (InternalEObject)this, 3);
        }
        return this.roleTypes;
    }

    @Override
    public Boolean getFree() {
        return this.free;
    }

    @Override
    public void setFree(Boolean newFree) {
        Boolean oldFree = this.free;
        this.free = newFree;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldFree, (Object)this.free));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getRoleTypes();
            }
            case 4: {
                return this.getFree();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getRoleTypes().clear();
                this.getRoleTypes().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setFree((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getRoleTypes().clear();
                return;
            }
            case 4: {
                this.setFree(FREE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.roleTypes != null && !this.roleTypes.isEmpty();
            }
            case 4: {
                return FREE_EDEFAULT == null ? this.free != null : !FREE_EDEFAULT.equals(this.free);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", free: ");
        result.append(this.free);
        result.append(')');
        return result.toString();
    }
}

