/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.SequenceImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalizerHandlerImpl
extends CDLTypeImpl
implements FinalizerHandler {
    public static final String NAME = "name";
    private boolean m_checkingIfRelevant = false;
    public static final String FINALIZER_TAGNAME = "finalizerBlock";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Activity> activities;

    @Override
    protected String getExportTagname() {
        return FINALIZER_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        Element base = elem;
        if (this.getActivities().size() > 1) {
            base = this.createCDLElement(parent, "sequence");
            elem.appendChild(base);
        }
        this.exportListAsDOMElements((List)this.getActivities(), base, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(FINALIZER_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
        }
        super.importFromDOMElement(elem, l, context);
        if (this.getActivities().size() == 1 && this.getActivities().get(0) instanceof SequenceImpl) {
            SequenceImpl seq = (SequenceImpl)this.getActivities().get(0);
            while (seq.getActivities().size() > 0) {
                Activity act = (Activity)seq.getActivities().get(0);
                seq.getActivities().remove(0);
                this.getActivities().add((Object)act);
            }
            this.getActivities().remove(0);
        }
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        Activity ret = null;
        Activity act = FinalizerHandlerImpl.createActivity(elem, l);
        if (act != null) {
            ret = act;
            this.getActivities().add((Object)act);
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Choreography choreo = this.getEnclosingChoreography();
        if (choreo != null && this.isSet(this.getName()) && choreo.getFinalizerHandler(this.getName()) != this) {
            l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
        }
    }

    @Override
    public boolean isGroupingConstruct() {
        return true;
    }

    @Override
    public boolean isSequentialGroupingConstruct() {
        return true;
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.finalizerStart(this);
        super.visit(visitor);
        visitor.finalizerEnd(this);
    }

    @Override
    public synchronized boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_checkingIfRelevant) {
            this.m_checkingIfRelevant = true;
            if (this.getEnclosingChoreography() != null) {
                ret = this.getEnclosingChoreography().isRelevantToRoleType(roleType);
            }
            this.m_checkingIfRelevant = false;
        }
        return ret;
    }

    protected FinalizerHandlerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.FINALIZER_HANDLER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Activity> getActivities() {
        if (this.activities == null) {
            this.activities = new EObjectContainmentEList(Activity.class, (InternalEObject)this, 3);
        }
        return this.activities;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getActivities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getActivities();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getActivities().clear();
                this.getActivities().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getActivities().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.activities != null && !this.activities.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

