/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ExceptionHandler;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
extends CDLTypeImpl
implements ExceptionHandler {
    public static final String NAME = "name";
    private boolean m_checkingIfRelevant = false;
    public static final String EXCEPTION_TAGNAME = "exceptionBlock";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<ExceptionWorkUnit> exceptionWorkUnits;

    @Override
    protected String getExportTagname() {
        return EXCEPTION_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        this.exportListAsDOMElements((List)this.getExceptionWorkUnits(), elem, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(EXCEPTION_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        ExceptionWorkUnit ret = null;
        String name = elem.getNodeName();
        if (name.equals("workunit")) {
            ret = CdlFactory.eINSTANCE.createExceptionWorkUnit();
            this.getExceptionWorkUnits().add((Object)ret);
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        int numOfDefaultWU = 0;
        for (ExceptionWorkUnit wu : this.getExceptionWorkUnits()) {
            if (wu.getExceptionType() != null) continue;
            ++numOfDefaultWU;
        }
        if (numOfDefaultWU > 1) {
            l.report((Object)this, this.getMessage("_ONLY_ONE_EXCEPTION_WORKUNIT", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"exceptionWorkUnits"));
        }
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.exceptionHandlerStart(this);
        super.visit(visitor);
        visitor.exceptionHandlerEnd(this);
    }

    @Override
    public synchronized boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_checkingIfRelevant) {
            this.m_checkingIfRelevant = true;
            if (this.getEnclosingChoreography() != null) {
                ret = this.getEnclosingChoreography().isRelevantToRoleType(roleType);
            }
            this.m_checkingIfRelevant = false;
        }
        return ret;
    }

    protected ExceptionHandlerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.EXCEPTION_HANDLER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<ExceptionWorkUnit> getExceptionWorkUnits() {
        if (this.exceptionWorkUnits == null) {
            this.exceptionWorkUnits = new EObjectContainmentEList(ExceptionWorkUnit.class, (InternalEObject)this, 3);
        }
        return this.exceptionWorkUnits;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getExceptionWorkUnits()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getExceptionWorkUnits();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getExceptionWorkUnits().clear();
                this.getExceptionWorkUnits().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getExceptionWorkUnits().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.exceptionWorkUnits != null && !this.exceptionWorkUnits.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

