/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.DefaultCDLVisitor;
import org.pi4soa.cdl.ExceptionHandler;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RelationshipType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.SequenceImpl;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoreographyImpl
extends CDLTypeImpl
implements Choreography {
    public static final String VARIABLEDEFINITIONS = "variableDefinitions";
    public static final String TYPE = "type";
    public static final String COORDINATION = "coordination";
    public static final String COMPLETE = "complete";
    public static final String ISOLATION = "isolation";
    public static final String ROOT = "root";
    public static final String NAME = "name";
    private boolean m_checkingIfRelevant = false;
    public static final String CHOREOGRAPHY_TAGNAME = "choreography";
    public static final String RELATIONSHIP_TAGNAME = "relationship";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String COMPLETION_CONDITION_EDEFAULT = null;
    protected String completionCondition = COMPLETION_CONDITION_EDEFAULT;
    protected static final Boolean ISOLATION_EDEFAULT = Boolean.FALSE;
    protected Boolean isolation = ISOLATION_EDEFAULT;
    protected static final Boolean ROOT_EDEFAULT = Boolean.FALSE;
    protected Boolean root = ROOT_EDEFAULT;
    protected static final Boolean COORDINATED_EDEFAULT = Boolean.FALSE;
    protected Boolean coordinated = COORDINATED_EDEFAULT;
    protected EList<RelationshipType> relationships;
    protected EList<Choreography> enclosedChoreographies;
    protected EList<Participant> participantDefinitions;
    protected EList<Variable> variableDefinitions;
    protected ExceptionHandler exceptionHandler;
    protected EList<FinalizerHandler> finalizers;
    protected EList<Activity> activities;

    @Override
    protected String getExportTagname() {
        return CHOREOGRAPHY_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.isSet(this.getRoot(), false)) {
            elem.setAttribute(ROOT, this.getRoot().toString());
        }
        if (this.isSet(this.getIsolation(), false)) {
            elem.setAttribute(ISOLATION, this.getIsolation().toString());
        }
        if (this.isSet(this.getCompletionCondition())) {
            elem.setAttribute(COMPLETE, this.getCompletionCondition());
        }
        if (this.isSet(this.getCoordinated(), false)) {
            elem.setAttribute(COORDINATION, this.getCoordinated().toString());
        }
        Iterator iter = null;
        iter = this.getRelationships().size() > 0 ? this.getRelationships().iterator() : this.getPackage().getTypeDefinitions().getRelationshipTypes().iterator();
        while (iter.hasNext()) {
            RelationshipType relationship = (RelationshipType)iter.next();
            Element relnode = elem.getOwnerDocument().createElementNS("http://www.w3.org/2005/10/cdl", RELATIONSHIP_TAGNAME);
            relnode.setAttribute(TYPE, ChoreographyImpl.addTNS(relationship.getName()));
            elem.appendChild(relnode);
        }
        if (this.getParticipantDefinitions() != null && this.getParticipantDefinitions().size() > 0) {
            this.exportListAsDOMElements((List)this.getParticipantDefinitions(), elem, l, context);
        }
        if (this.getVariableDefinitions() != null && this.getVariableDefinitions().size() > 0) {
            Element vardefns = elem.getOwnerDocument().createElementNS("http://www.w3.org/2005/10/cdl", VARIABLEDEFINITIONS);
            this.exportListAsDOMElements((List)this.getVariableDefinitions(), vardefns, l, context);
            elem.appendChild(vardefns);
        }
        this.exportListAsDOMElements((List)this.getEnclosedChoreographies(), elem, l, context);
        Element base = elem;
        if (this.getActivities().size() > 1) {
            base = this.createCDLElement(parent, "sequence");
            elem.appendChild(base);
        }
        this.exportListAsDOMElements((List)this.getActivities(), base, l, context);
        if (this.getExceptionHandler() != null) {
            ChoreographyImpl.exportAsDOMElement(this.getExceptionHandler(), elem, l, context);
        }
        this.exportListAsDOMElements((List)this.getFinalizers(), elem, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(CHOREOGRAPHY_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
            this.setCompletionCondition(elem.getAttribute(COMPLETE));
            this.setIsolation(this.importBoolean(elem.getAttribute(ISOLATION), false));
            this.setRoot(this.importBoolean(elem.getAttribute(ROOT), false));
            this.setCoordinated(this.importBoolean(elem.getAttribute(COORDINATION), false));
            this.importRelationships(elem, l);
            this.importVariableDefinitions(elem, l, context);
        }
        super.importFromDOMElement(elem, l, context);
        if (this.getActivities().size() == 1 && this.getActivities().get(0) instanceof SequenceImpl) {
            SequenceImpl seq = (SequenceImpl)this.getActivities().get(0);
            while (seq.getActivities().size() > 0) {
                Activity act = (Activity)seq.getActivities().get(0);
                seq.getActivities().remove(0);
                this.getActivities().add((Object)act);
            }
            this.getActivities().remove(0);
        }
    }

    protected void importRelationships(Element elem, ModelListener l) {
        NodeList nl = elem.getChildNodes();
        Package cdlpack = this.getPackage();
        int i = 0;
        while (cdlpack != null && i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(RELATIONSHIP_TAGNAME) && nl.item(i) instanceof Element) {
                Element rel = (Element)nl.item(i);
                String type = rel.getAttribute(TYPE);
                if (!this.isSet(type)) {
                    l.report((Object)this, this.getMessage("_NO_TYPE_FOR_CHOREO_REL", new Object[]{this.getName()}), 2);
                } else {
                    RelationshipType relType = cdlpack.getRelationshipType(type);
                    if (relType != null) {
                        if (this.getRelationships().contains((Object)relType)) {
                            l.report((Object)this, this.getMessage("_DUPLICATE_REL_TYPE_IN_CHOREO", new Object[]{type, this.getName()}), 2);
                        } else {
                            this.getRelationships().add((Object)relType);
                        }
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_REL_TYPE", new Object[]{type}), 2);
                    }
                }
            }
            ++i;
        }
        if (this.getRelationships().size() == 0) {
            l.report((Object)this, this.getMessage("_NO_REL_TYPE_IN_CHOREO", new Object[]{this.getName()}), 2);
        } else if (this.getRelationships().size() == cdlpack.getTypeDefinitions().getRelationshipTypes().size()) {
            this.getRelationships().clear();
        }
    }

    protected void importVariableDefinitions(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        Element vardefns = null;
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (vardefns == null && i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(VARIABLEDEFINITIONS)) {
                vardefns = (Element)nl.item(i);
            }
            ++i;
        }
        if (vardefns != null) {
            super.importFromDOMElement(vardefns, l, context);
        }
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        Activity act;
        CDLType ret = null;
        String name = elem.getLocalName();
        if (elem.getNamespaceURI() != null) {
            if (elem.getNamespaceURI().equals("http://www.w3.org/2005/10/cdl")) {
                if (name.equals("variable")) {
                    ret = CdlFactory.eINSTANCE.createVariable();
                    this.getVariableDefinitions().add((Object)((Variable)ret));
                } else if (name.equals(CHOREOGRAPHY_TAGNAME)) {
                    ret = CdlFactory.eINSTANCE.createChoreography();
                    this.getEnclosedChoreographies().add((Object)((Choreography)ret));
                } else if (name.equals("exceptionBlock")) {
                    ret = CdlFactory.eINSTANCE.createExceptionHandler();
                    this.setExceptionHandler((ExceptionHandler)ret);
                } else if (name.equals("finalizerBlock")) {
                    ret = CdlFactory.eINSTANCE.createFinalizerHandler();
                    this.getFinalizers().add((Object)((FinalizerHandler)ret));
                }
            } else if (elem.getNamespaceURI().equals("http://www.pi4soa.org/cdl2") && name.equals("participant")) {
                ret = CdlFactory.eINSTANCE.createParticipant();
                this.getParticipantDefinitions().add((Object)((Participant)ret));
            }
        }
        if (ret == null && (act = ChoreographyImpl.createActivity(elem, l)) != null) {
            ret = act;
            this.getActivities().add((Object)act);
        }
        return ret;
    }

    @Override
    public Variable getVariable(String name) {
        return (Variable)this.getNamedCDLType(name, (List)this.getVariableDefinitions());
    }

    @Override
    public Participant getParticipant(String name) {
        return (Participant)this.getNamedCDLType(name, (List)this.getParticipantDefinitions());
    }

    @Override
    public Participant[] getParticipantsForRoleTypes(RoleType[] roleTypes) {
        Object[] ret = null;
        Vector<Participant> v = new Vector<Participant>();
        Iterator iter = this.getParticipantDefinitions().iterator();
        while (roleTypes != null && iter.hasNext()) {
            Participant part = (Participant)iter.next();
            boolean f_found = false;
            int i = 0;
            while (!f_found && i < roleTypes.length) {
                if (part.getRoleTypes().contains((Object)roleTypes[i])) {
                    f_found = true;
                }
                ++i;
            }
            if (!f_found) continue;
            v.add(part);
        }
        ret = new Participant[v.size()];
        v.copyInto(ret);
        return ret;
    }

    @Override
    public Choreography getEnclosedChoreography(String name) {
        return (Choreography)this.getNamedCDLType(name, (List)this.getEnclosedChoreographies());
    }

    @Override
    public Choreography getEnclosingChoreography() {
        return this;
    }

    @Override
    public FinalizerHandler getFinalizerHandler(String name) {
        return (FinalizerHandler)this.getNamedCDLType(name, (List)this.getFinalizers());
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.isSet(this.getName())) {
            Package parent;
            boolean f_duplicate = false;
            if (this.getParent() instanceof Choreography) {
                Choreography parent2 = (Choreography)this.getParent();
                if (parent2.getEnclosedChoreography(this.getName()) != this) {
                    f_duplicate = true;
                } else if (this.getPackage().getChoreography(this.getName()) != null) {
                    f_duplicate = true;
                }
            } else if (this.getParent() instanceof Package && (parent = (Package)this.getParent()).getChoreography(this.getName()) != this) {
                f_duplicate = true;
            }
            if (f_duplicate) {
                l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
            }
        }
        if (this.getRoot() != null && this.getRoot().booleanValue() && this.getParent() instanceof Choreography) {
            l.report((Object)this, this.getMessage("_ONLY_TOP_LEVEL_CHOREO_ROOT", null), 2, ValidationDefinitions.getPropertyNameInfo((String)ROOT));
        }
        if (this.isSet(this.getCompletionCondition())) {
            XPathContext xpcontext = DefaultXPathContext.createContext(this, this, l);
            xpcontext.setMessagePrefix(this.getMessage("_COMPLETION_EXPRESSION", null));
            XPathValidator.validateExpression(xpcontext, this.getCompletionCondition(), this.getRoleTypesForContext(), null, true);
        }
    }

    @Override
    public RoleType[] getRoleTypesForContext() {
        RoleType[] roleTypes = null;
        Vector<RoleType> roles = new Vector<RoleType>();
        Iterator iter = null;
        if (this.getRelationships().size() > 0) {
            iter = this.getRelationships().iterator();
        } else if (this.getPackage() != null) {
            iter = this.getPackage().getTypeDefinitions().getRelationshipTypes().iterator();
        }
        while (iter != null && iter.hasNext()) {
            RelationshipType rel = (RelationshipType)iter.next();
            if (rel.getFirstRoleType() != null && !roles.contains(rel.getFirstRoleType())) {
                roles.add(rel.getFirstRoleType());
            }
            if (rel.getSecondRoleType() == null || roles.contains(rel.getSecondRoleType())) continue;
            roles.add(rel.getSecondRoleType());
        }
        roleTypes = new RoleType[roles.size()];
        int i = 0;
        while (i < roles.size()) {
            roleTypes[i] = (RoleType)roles.get(i);
            ++i;
        }
        return roleTypes;
    }

    @Override
    public boolean isGroupingConstruct() {
        return true;
    }

    @Override
    public boolean isSequentialGroupingConstruct() {
        return true;
    }

    @Override
    public boolean hasCompletionCondition() {
        return NamesUtil.isSet((String)this.getCompletionCondition());
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.choreographyStart(this);
        super.visit(visitor);
        visitor.choreographyEnd(this);
    }

    @Override
    public String getFullyQualifiedName() {
        String ret = this.getName();
        if (super.getEnclosingChoreography() != null) {
            ret = String.valueOf(super.getEnclosingChoreography().getFullyQualifiedName()) + "." + ret;
        }
        return ret;
    }

    @Override
    public synchronized boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_checkingIfRelevant) {
            this.m_checkingIfRelevant = true;
            ret = super.isRelevantToRoleType(roleType);
            this.m_checkingIfRelevant = false;
        }
        return ret;
    }

    @Override
    public List<Perform> getPerformingActivities() {
        final Vector<Perform> ret = new Vector<Perform>();
        this.getPackage().visit(new DefaultCDLVisitor(){

            public void perform(Perform perform) {
                if (perform.getChoreography() == ChoreographyImpl.this) {
                    ret.add(perform);
                }
            }
        });
        return ret;
    }

    protected ChoreographyImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.CHOREOGRAPHY;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getCompletionCondition() {
        return this.completionCondition;
    }

    @Override
    public void setCompletionCondition(String newCompletionCondition) {
        String oldCompletionCondition = this.completionCondition;
        this.completionCondition = newCompletionCondition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldCompletionCondition, (Object)this.completionCondition));
        }
    }

    @Override
    public Boolean getIsolation() {
        return this.isolation;
    }

    @Override
    public void setIsolation(Boolean newIsolation) {
        Boolean oldIsolation = this.isolation;
        this.isolation = newIsolation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldIsolation, (Object)this.isolation));
        }
    }

    @Override
    public Boolean getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Boolean newRoot) {
        Boolean oldRoot = this.root;
        this.root = newRoot;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldRoot, (Object)this.root));
        }
    }

    @Override
    public EList<RelationshipType> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new EObjectResolvingEList(RelationshipType.class, (InternalEObject)this, 7);
        }
        return this.relationships;
    }

    @Override
    public EList<Choreography> getEnclosedChoreographies() {
        if (this.enclosedChoreographies == null) {
            this.enclosedChoreographies = new EObjectContainmentEList(Choreography.class, (InternalEObject)this, 8);
        }
        return this.enclosedChoreographies;
    }

    @Override
    public Boolean getCoordinated() {
        return this.coordinated;
    }

    @Override
    public void setCoordinated(Boolean newCoordinated) {
        Boolean oldCoordinated = this.coordinated;
        this.coordinated = newCoordinated;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldCoordinated, (Object)this.coordinated));
        }
    }

    @Override
    public EList<Participant> getParticipantDefinitions() {
        if (this.participantDefinitions == null) {
            this.participantDefinitions = new EObjectContainmentEList(Participant.class, (InternalEObject)this, 9);
        }
        return this.participantDefinitions;
    }

    @Override
    public EList<Variable> getVariableDefinitions() {
        if (this.variableDefinitions == null) {
            this.variableDefinitions = new EObjectContainmentEList(Variable.class, (InternalEObject)this, 10);
        }
        return this.variableDefinitions;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public NotificationChain basicSetExceptionHandler(ExceptionHandler newExceptionHandler, NotificationChain msgs) {
        ExceptionHandler oldExceptionHandler = this.exceptionHandler;
        this.exceptionHandler = newExceptionHandler;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldExceptionHandler, (Object)newExceptionHandler);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler newExceptionHandler) {
        if (newExceptionHandler != this.exceptionHandler) {
            NotificationChain msgs = null;
            if (this.exceptionHandler != null) {
                msgs = ((InternalEObject)this.exceptionHandler).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newExceptionHandler != null) {
                msgs = ((InternalEObject)newExceptionHandler).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetExceptionHandler(newExceptionHandler, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newExceptionHandler, (Object)newExceptionHandler));
        }
    }

    @Override
    public EList<FinalizerHandler> getFinalizers() {
        if (this.finalizers == null) {
            this.finalizers = new EObjectContainmentEList(FinalizerHandler.class, (InternalEObject)this, 12);
        }
        return this.finalizers;
    }

    @Override
    public EList<Activity> getActivities() {
        if (this.activities == null) {
            this.activities = new EObjectContainmentEList(Activity.class, (InternalEObject)this, 13);
        }
        return this.activities;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getEnclosedChoreographies()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getParticipantDefinitions()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getVariableDefinitions()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetExceptionHandler(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getFinalizers()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getActivities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getCompletionCondition();
            }
            case 4: {
                return this.getIsolation();
            }
            case 5: {
                return this.getRoot();
            }
            case 6: {
                return this.getCoordinated();
            }
            case 7: {
                return this.getRelationships();
            }
            case 8: {
                return this.getEnclosedChoreographies();
            }
            case 9: {
                return this.getParticipantDefinitions();
            }
            case 10: {
                return this.getVariableDefinitions();
            }
            case 11: {
                return this.getExceptionHandler();
            }
            case 12: {
                return this.getFinalizers();
            }
            case 13: {
                return this.getActivities();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setCompletionCondition((String)newValue);
                return;
            }
            case 4: {
                this.setIsolation((Boolean)newValue);
                return;
            }
            case 5: {
                this.setRoot((Boolean)newValue);
                return;
            }
            case 6: {
                this.setCoordinated((Boolean)newValue);
                return;
            }
            case 7: {
                this.getRelationships().clear();
                this.getRelationships().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getEnclosedChoreographies().clear();
                this.getEnclosedChoreographies().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getParticipantDefinitions().clear();
                this.getParticipantDefinitions().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getVariableDefinitions().clear();
                this.getVariableDefinitions().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setExceptionHandler((ExceptionHandler)newValue);
                return;
            }
            case 12: {
                this.getFinalizers().clear();
                this.getFinalizers().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getActivities().clear();
                this.getActivities().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setCompletionCondition(COMPLETION_CONDITION_EDEFAULT);
                return;
            }
            case 4: {
                this.setIsolation(ISOLATION_EDEFAULT);
                return;
            }
            case 5: {
                this.setRoot(ROOT_EDEFAULT);
                return;
            }
            case 6: {
                this.setCoordinated(COORDINATED_EDEFAULT);
                return;
            }
            case 7: {
                this.getRelationships().clear();
                return;
            }
            case 8: {
                this.getEnclosedChoreographies().clear();
                return;
            }
            case 9: {
                this.getParticipantDefinitions().clear();
                return;
            }
            case 10: {
                this.getVariableDefinitions().clear();
                return;
            }
            case 11: {
                this.setExceptionHandler(null);
                return;
            }
            case 12: {
                this.getFinalizers().clear();
                return;
            }
            case 13: {
                this.getActivities().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return COMPLETION_CONDITION_EDEFAULT == null ? this.completionCondition != null : !COMPLETION_CONDITION_EDEFAULT.equals(this.completionCondition);
            }
            case 4: {
                return ISOLATION_EDEFAULT == null ? this.isolation != null : !ISOLATION_EDEFAULT.equals(this.isolation);
            }
            case 5: {
                return ROOT_EDEFAULT == null ? this.root != null : !ROOT_EDEFAULT.equals(this.root);
            }
            case 6: {
                return COORDINATED_EDEFAULT == null ? this.coordinated != null : !COORDINATED_EDEFAULT.equals(this.coordinated);
            }
            case 7: {
                return this.relationships != null && !this.relationships.isEmpty();
            }
            case 8: {
                return this.enclosedChoreographies != null && !this.enclosedChoreographies.isEmpty();
            }
            case 9: {
                return this.participantDefinitions != null && !this.participantDefinitions.isEmpty();
            }
            case 10: {
                return this.variableDefinitions != null && !this.variableDefinitions.isEmpty();
            }
            case 11: {
                return this.exceptionHandler != null;
            }
            case 12: {
                return this.finalizers != null && !this.finalizers.isEmpty();
            }
            case 13: {
                return this.activities != null && !this.activities.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", completionCondition: ");
        result.append(this.completionCondition);
        result.append(", isolation: ");
        result.append(this.isolation);
        result.append(", root: ");
        result.append(this.root);
        result.append(", coordinated: ");
        result.append(this.coordinated);
        result.append(')');
        return result.toString();
    }
}

