/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.BindDetails;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.PerformImpl;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BindDetailsImpl
extends CDLTypeImpl
implements BindDetails {
    public static final String FREE = "free";
    public static final String ROLETYPE = "roleType";
    public static final String VARIABLE = "variable";
    public static final String THIS = "this";
    public static final String NAME = "name";
    private String m_thisVariableName = null;
    private String m_freeVariableName = null;
    public static final String BINDDETAILS_TAGNAME = "bind";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected Variable thisVariable;
    protected RoleType thisRole;
    protected Variable freeVariable;
    protected RoleType freeRole;

    protected String getExportTagname() {
        return BINDDETAILS_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        Element thisnode = this.createCDLElement(elem, THIS);
        if (this.getThisVariable() != null) {
            thisnode.setAttribute(VARIABLE, "cdl:getVariable('" + this.getThisVariable().getName() + "','','')");
        }
        if (this.getThisRole() != null) {
            thisnode.setAttribute(ROLETYPE, BindDetailsImpl.addTNS(this.getThisRole().getName()));
        }
        elem.appendChild(thisnode);
        Element freenode = this.createCDLElement(elem, FREE);
        if (this.getFreeVariable() != null) {
            freenode.setAttribute(VARIABLE, "cdl:getVariable('" + this.getFreeVariable().getName() + "','','')");
        }
        if (this.getFreeRole() != null) {
            freenode.setAttribute(ROLETYPE, BindDetailsImpl.addTNS(this.getFreeRole().getName()));
        }
        elem.appendChild(freenode);
        return elem;
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(BINDDETAILS_TAGNAME)) {
            RoleType roleType;
            String role;
            this.setName(elem.getAttribute(NAME));
            Package cdlpack = this.getPackage();
            NodeList thisNode = elem.getElementsByTagName(THIS);
            NodeList freeNode = elem.getElementsByTagName(FREE);
            if (thisNode.getLength() == 1) {
                Element thisElem = (Element)thisNode.item(0);
                this.m_thisVariableName = thisElem.getAttribute(VARIABLE);
                if (cdlpack != null) {
                    role = thisElem.getAttribute(ROLETYPE);
                    roleType = cdlpack.getRoleType(role);
                    if (roleType == null) {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{role}), 2);
                    } else {
                        this.setThisRole(roleType);
                    }
                }
            } else if (thisNode.getLength() == 0) {
                l.report((Object)this, this.getMessage("_MISSING_CHILD_NODE", new Object[]{THIS, BINDDETAILS_TAGNAME}), 2);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_SINGLE_CHILD_NODE", new Object[]{THIS, BINDDETAILS_TAGNAME}), 2);
            }
            if (freeNode.getLength() == 1) {
                Element freeElem = (Element)freeNode.item(0);
                this.m_freeVariableName = freeElem.getAttribute(VARIABLE);
                if (cdlpack != null) {
                    role = freeElem.getAttribute(ROLETYPE);
                    roleType = cdlpack.getRoleType(role);
                    if (roleType == null) {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{role}), 2);
                    } else {
                        this.setFreeRole(roleType);
                    }
                }
            } else if (freeNode.getLength() == 0) {
                l.report((Object)this, this.getMessage("_MISSING_CHILD_NODE", new Object[]{FREE, BINDDETAILS_TAGNAME}), 2);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_SINGLE_CHILD_NODE", new Object[]{FREE, BINDDETAILS_TAGNAME}), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    public void initialize(ModelListener l) {
        super.initialize(l);
        if (this.isSet(this.m_thisVariableName) && this.getEnclosingChoreography() != null) {
            XPathContext context = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_THIS_VARIABLE", null));
            ValidationResult res = XPathValidator.validateVariable(context, this.m_thisVariableName, this.getRoleTypesForContext(), false);
            if (res != null && res.getVariable() != null) {
                this.setThisVariable(res.getVariable());
            }
            if (res != null && (NamesUtil.isSet((String)res.getDocumentPath()) || NamesUtil.isSet((String)res.getPartName()))) {
                l.report((Object)this, String.valueOf(this.getMessage("_THIS_VARIABLE", null)) + ": " + this.getMessage("_SPECIFY_NO_PART_OR_QUERY", new Object[0]), 2);
            }
        } else {
            l.report((Object)this, String.valueOf(this.getMessage("_THIS_VARIABLE", null)) + ": " + this.getMessage("_XPATH_MUST_USE_FUNCTION", new Object[]{"getVariable"}), 2);
        }
        if (this.isSet(this.m_freeVariableName) && this.getParent() instanceof PerformImpl && ((PerformImpl)this.getParent()).getChoreography() != null) {
            Choreography choreo = ((PerformImpl)this.getParent()).getChoreography();
            XPathContext context = DefaultXPathContext.createContext(this, choreo, l, this.getMessage("_FREE_VARIABLE", null));
            ValidationResult res = XPathValidator.validateVariable(context, this.m_freeVariableName, choreo.getRoleTypesForContext(), false);
            if (res != null && res.getVariable() != null) {
                this.setFreeVariable(res.getVariable());
            }
            if (res != null && (NamesUtil.isSet((String)res.getDocumentPath()) || NamesUtil.isSet((String)res.getPartName()))) {
                l.report((Object)this, String.valueOf(this.getMessage("_FREE_VARIABLE", null)) + ": " + this.getMessage("_SPECIFY_NO_PART_OR_QUERY", new Object[0]), 2);
            }
        } else {
            l.report((Object)this, String.valueOf(this.getMessage("_FREE_VARIABLE", null)) + ": " + this.getMessage("_XPATH_MUST_USE_FUNCTION", new Object[]{"getVariable"}), 2);
        }
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.getThisVariable() != null && this.getThisVariable().getEnclosingChoreography() != this.getEnclosingChoreography()) {
            l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{this.getThisVariable().getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"thisVariable"));
        }
        Choreography performedChoreo = null;
        if (this.getParent() instanceof PerformImpl) {
            performedChoreo = ((PerformImpl)this.getParent()).getChoreography();
        }
        if (performedChoreo != null && this.getFreeVariable() != null && this.getFreeVariable().getEnclosingChoreography() != performedChoreo) {
            l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{this.getFreeVariable().getName(), performedChoreo.getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"freeVariable"));
        }
        this.validateVariables(l);
        this.validateRoleTypes(l);
    }

    protected void validateVariables(ModelListener l) throws ValidationException {
        if (this.getThisVariable() != null && this.getFreeVariable() != null) {
            if (this.isSet(this.getThisVariable().getMutable(), true) != this.isSet(this.getFreeVariable().getMutable(), true)) {
                l.report((Object)this, this.getMessage("_INCOMPATIBLE_MUTABLE", null), 2);
            }
            if (!this.isSet(this.getFreeVariable().getFree(), false)) {
                l.report((Object)this, this.getMessage("_NOT_FREE_VARIABLE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"freeVariable"));
            }
            if (this.isSet(this.getThisVariable().getSilent(), false) != this.isSet(this.getFreeVariable().getSilent(), false)) {
                l.report((Object)this, this.getMessage("_INCOMPATIBLE_SILENT", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"thisVariable"));
            }
            if (this.getThisVariable().getType() != this.getFreeVariable().getType()) {
                l.report((Object)this, this.getMessage("_INCOMPATIBLE_BIND_VARIABLE_TYPES", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"thisVariable"));
            }
        }
    }

    protected void validateRoleTypes(ModelListener l) throws ValidationException {
        if (this.getThisRole() != null && this.getFreeRole() != null && PackageUtil.getParticipantForRoleType(this.getThisRole()) != PackageUtil.getParticipantForRoleType(this.getFreeRole())) {
            l.report((Object)this, this.getMessage("_BIND_ROLES_AT_DIFF_PARTICIPANTS", null), 2);
        }
        if (this.getThisRole() != null && this.getThisVariable() != null && !this.getThisVariable().isRoleTypeAssociatedWithContext(this.getThisRole().getName())) {
            l.report((Object)this, this.getMessage("_BIND_VARIABLE_NOT_AT_ROLE", new String[]{this.getMessage("_THIS_VARIABLE", null)}), 2, ValidationDefinitions.getPropertyNameInfo((String)"thisVariable"));
        }
        if (this.getFreeRole() != null && this.getFreeVariable() != null && !this.getFreeVariable().isRoleTypeAssociatedWithContext(this.getFreeRole().getName())) {
            l.report((Object)this, this.getMessage("_BIND_VARIABLE_NOT_AT_ROLE", new String[]{this.getMessage("_FREE_VARIABLE", null)}), 2, ValidationDefinitions.getPropertyNameInfo((String)"freeVariable"));
        }
    }

    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<String> ret = new Vector<String>();
        if (this.getThisRole() != null) {
            ret.add(this.getThisRole().getName());
        }
        if (this.getFreeRole() != null) {
            ret.add(this.getFreeRole().getName());
        }
        return ret;
    }

    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (this.getThisRole() != null && roleType != null) {
            ret = this.getThisRole().equals(roleType);
        }
        if (!ret && this.getFreeRole() != null && roleType != null) {
            ret = this.getFreeRole().equals(roleType);
        }
        return ret;
    }

    protected BindDetailsImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.BIND_DETAILS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    public Variable getThisVariable() {
        if (this.thisVariable != null && this.thisVariable.eIsProxy()) {
            InternalEObject oldThisVariable = (InternalEObject)this.thisVariable;
            this.thisVariable = (Variable)this.eResolveProxy(oldThisVariable);
            if (this.thisVariable != oldThisVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldThisVariable, (Object)this.thisVariable));
            }
        }
        return this.thisVariable;
    }

    public Variable basicGetThisVariable() {
        return this.thisVariable;
    }

    public void setThisVariable(Variable newThisVariable) {
        Variable oldThisVariable = this.thisVariable;
        this.thisVariable = newThisVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldThisVariable, (Object)this.thisVariable));
        }
    }

    public RoleType getThisRole() {
        if (this.thisRole != null && this.thisRole.eIsProxy()) {
            InternalEObject oldThisRole = (InternalEObject)this.thisRole;
            this.thisRole = (RoleType)this.eResolveProxy(oldThisRole);
            if (this.thisRole != oldThisRole && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldThisRole, (Object)this.thisRole));
            }
        }
        return this.thisRole;
    }

    public RoleType basicGetThisRole() {
        return this.thisRole;
    }

    public void setThisRole(RoleType newThisRole) {
        RoleType oldThisRole = this.thisRole;
        this.thisRole = newThisRole;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldThisRole, (Object)this.thisRole));
        }
    }

    public Variable getFreeVariable() {
        if (this.freeVariable != null && this.freeVariable.eIsProxy()) {
            InternalEObject oldFreeVariable = (InternalEObject)this.freeVariable;
            this.freeVariable = (Variable)this.eResolveProxy(oldFreeVariable);
            if (this.freeVariable != oldFreeVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldFreeVariable, (Object)this.freeVariable));
            }
        }
        return this.freeVariable;
    }

    public Variable basicGetFreeVariable() {
        return this.freeVariable;
    }

    public void setFreeVariable(Variable newFreeVariable) {
        Variable oldFreeVariable = this.freeVariable;
        this.freeVariable = newFreeVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFreeVariable, (Object)this.freeVariable));
        }
    }

    public RoleType getFreeRole() {
        if (this.freeRole != null && this.freeRole.eIsProxy()) {
            InternalEObject oldFreeRole = (InternalEObject)this.freeRole;
            this.freeRole = (RoleType)this.eResolveProxy(oldFreeRole);
            if (this.freeRole != oldFreeRole && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldFreeRole, (Object)this.freeRole));
            }
        }
        return this.freeRole;
    }

    public RoleType basicGetFreeRole() {
        return this.freeRole;
    }

    public void setFreeRole(RoleType newFreeRole) {
        RoleType oldFreeRole = this.freeRole;
        this.freeRole = newFreeRole;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldFreeRole, (Object)this.freeRole));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getThisVariable();
                }
                return this.basicGetThisVariable();
            }
            case 4: {
                if (resolve) {
                    return this.getThisRole();
                }
                return this.basicGetThisRole();
            }
            case 5: {
                if (resolve) {
                    return this.getFreeVariable();
                }
                return this.basicGetFreeVariable();
            }
            case 6: {
                if (resolve) {
                    return this.getFreeRole();
                }
                return this.basicGetFreeRole();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setThisVariable((Variable)newValue);
                return;
            }
            case 4: {
                this.setThisRole((RoleType)newValue);
                return;
            }
            case 5: {
                this.setFreeVariable((Variable)newValue);
                return;
            }
            case 6: {
                this.setFreeRole((RoleType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setThisVariable(null);
                return;
            }
            case 4: {
                this.setThisRole(null);
                return;
            }
            case 5: {
                this.setFreeVariable(null);
                return;
            }
            case 6: {
                this.setFreeRole(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.thisVariable != null;
            }
            case 4: {
                return this.thisRole != null;
            }
            case 5: {
                return this.freeVariable != null;
            }
            case 6: {
                return this.freeRole != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

