/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Assign;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.CopyDetails;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.ActivityImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignImpl
extends ActivityImpl
implements Assign {
    public static final String ROLETYPE = "roleType";
    public static final String PARTICIPANT = "participant";
    public static final String ASSIGN_TAGNAME = "assign";
    protected EList<CopyDetails> copyDetails;
    protected RoleType roleType;
    protected Participant participant;

    @Override
    protected String getExportTagname() {
        return ASSIGN_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getRoleType() != null) {
            elem.setAttribute(ROLETYPE, AssignImpl.addTNS(this.getRoleType().getName()));
        }
        if (context.isVersionSupported(2) && this.getParticipant() != null) {
            elem.setAttribute("cdl2:participant", this.getParticipant().getName());
        }
        this.exportListAsDOMElements((List)this.getCopyDetails(), elem, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(ASSIGN_TAGNAME)) {
            String participantName;
            String roleTypeName = elem.getAttribute(ROLETYPE);
            Package cdlpack = this.getPackage();
            if (cdlpack != null) {
                RoleType roleType = cdlpack.getRoleType(roleTypeName);
                if (roleType == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{roleTypeName}), 2);
                } else {
                    this.setRoleType(roleType);
                }
            }
            if (this.isSet(participantName = elem.getAttributeNS("http://www.pi4soa.org/cdl2", PARTICIPANT))) {
                Participant participant = this.getEnclosingChoreography().getParticipant(participantName);
                if (participant == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT", new Object[]{participantName}), 2);
                } else {
                    this.setParticipant(participant);
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        CopyDetails ret = null;
        String name = elem.getNodeName();
        if (name.equals("copy")) {
            ret = CdlFactory.eINSTANCE.createCopyDetails();
            this.getCopyDetails().add((Object)ret);
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        Choreography choreo;
        super.validateSyntax(l, context);
        if (this.getRoleType() != null && (choreo = this.getEnclosingChoreography()) != null && !choreo.isRoleTypeAssociatedWithContext(this.getRoleType().getName())) {
            l.report((Object)this, this.getMessage("_NOT_RELEVANT_ROLE_TYPE", new Object[]{this.getRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)ROLETYPE));
        }
        int exc = 0;
        for (CopyDetails cd : this.getCopyDetails()) {
            if (!NamesUtil.isSet((String)cd.getCauseException())) continue;
            ++exc;
        }
        if (exc > 1) {
            l.report((Object)this, this.getMessage("_TOO_MANY_EXCEPTION_ELEMENTS", new Object[]{"assignment", "copy"}), 2, ValidationDefinitions.getPropertyNameInfo((String)"copyDetails"));
        }
        if (context.isVersionSupported(2)) {
            if (this.getParticipant() != null && this.getParticipant().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT_IN_CHOREO", new Object[]{this.getParticipant().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)PARTICIPANT));
            }
            if (this.getRoleType() != null && this.getParticipant() == null) {
                List ptypes = PackageUtil.getParticipantTypesForRoleType(this.getRoleType());
                boolean f_error = false;
                if (ptypes.size() > 1) {
                    f_error = true;
                } else if (ptypes.size() == 1) {
                    ParticipantType ptype = (ParticipantType)ptypes.get(0);
                    Participant[] parts = this.getEnclosingChoreography().getParticipantsForRoleTypes(ptype.getRoleTypesForContext());
                    if (parts != null && parts.length > 0) {
                        f_error = true;
                    }
                }
                if (f_error) {
                    l.report((Object)this, this.getMessage("_PARTICIPANT_DECLARED_FOR_ROLE", new Object[]{this.getRoleType().getName()}), 2);
                }
            }
        }
    }

    @Override
    public RoleType[] getRoleTypesForContext() {
        RoleType[] ret = null;
        ret = this.getRoleType() != null ? new RoleType[]{this.getRoleType()} : new RoleType[]{};
        return ret;
    }

    @Override
    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<String> ret = new Vector<String>();
        if (this.getRoleType() != null) {
            ret.add(this.getRoleType().getName());
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (this.getRoleType() != null && roleType != null) {
            ret = this.getRoleType().equals(roleType);
        }
        return ret;
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.assign(this);
        super.visit(visitor);
    }

    protected AssignImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.ASSIGN;
    }

    @Override
    public EList<CopyDetails> getCopyDetails() {
        if (this.copyDetails == null) {
            this.copyDetails = new EObjectContainmentEList(CopyDetails.class, (InternalEObject)this, 2);
        }
        return this.copyDetails;
    }

    @Override
    public RoleType getRoleType() {
        if (this.roleType != null && this.roleType.eIsProxy()) {
            InternalEObject oldRoleType = (InternalEObject)this.roleType;
            this.roleType = (RoleType)this.eResolveProxy(oldRoleType);
            if (this.roleType != oldRoleType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldRoleType, (Object)this.roleType));
            }
        }
        return this.roleType;
    }

    public RoleType basicGetRoleType() {
        return this.roleType;
    }

    @Override
    public void setRoleType(RoleType newRoleType) {
        RoleType oldRoleType = this.roleType;
        this.roleType = newRoleType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldRoleType, (Object)this.roleType));
        }
    }

    @Override
    public Participant getParticipant() {
        if (this.participant != null && this.participant.eIsProxy()) {
            InternalEObject oldParticipant = (InternalEObject)this.participant;
            this.participant = (Participant)this.eResolveProxy(oldParticipant);
            if (this.participant != oldParticipant && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldParticipant, (Object)this.participant));
            }
        }
        return this.participant;
    }

    public Participant basicGetParticipant() {
        return this.participant;
    }

    @Override
    public void setParticipant(Participant newParticipant) {
        Participant oldParticipant = this.participant;
        this.participant = newParticipant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldParticipant, (Object)this.participant));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getCopyDetails()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getCopyDetails();
            }
            case 3: {
                if (resolve) {
                    return this.getRoleType();
                }
                return this.basicGetRoleType();
            }
            case 4: {
                if (resolve) {
                    return this.getParticipant();
                }
                return this.basicGetParticipant();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getCopyDetails().clear();
                this.getCopyDetails().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setRoleType((RoleType)newValue);
                return;
            }
            case 4: {
                this.setParticipant((Participant)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getCopyDetails().clear();
                return;
            }
            case 3: {
                this.setRoleType(null);
                return;
            }
            case 4: {
                this.setParticipant(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.copyDetails != null && !this.copyDetails.isEmpty();
            }
            case 3: {
                return this.roleType != null;
            }
            case 4: {
                return this.participant != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

