/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse.properties;

import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class MonitorPropertyPage
extends PropertyPage {
    private static Logger logger = Logger.getLogger("org.pi4soa.common.eclipse.properties");
    private static final String PATH_TITLE = "Path:";
    private static final String ENABLED_TITLE = "&Monitoring Enabled:";
    private static final int DEFAULT_INDEX = 0;
    private Combo m_monitoringEnabled = null;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(((IResource)this.getElement()).getFullPath().toString());
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label enabledLabel = new Label(composite, 0);
        enabledLabel.setText(ENABLED_TITLE);
        this.m_monitoringEnabled = new Combo(composite, 12);
        this.m_monitoringEnabled.add(Boolean.FALSE.toString());
        this.m_monitoringEnabled.add(Boolean.TRUE.toString());
        try {
            String enabled = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("org.pi4soa.cdl", "monitoringEnabled"));
            if (enabled == null) {
                this.m_monitoringEnabled.select(0);
            } else if (enabled.equalsIgnoreCase(Boolean.TRUE.toString())) {
                this.m_monitoringEnabled.select(this.m_monitoringEnabled.getItemCount() - 1);
            } else {
                this.m_monitoringEnabled.select(this.m_monitoringEnabled.getItemCount() - 2);
            }
        }
        catch (CoreException coreException) {
            this.m_monitoringEnabled.select(0);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        try {
            String val = this.m_monitoringEnabled.getItem(this.m_monitoringEnabled.getSelectionIndex());
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("org.pi4soa.cdl", "monitoringEnabled"), val);
            this.updateResource();
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    protected void updateResource() throws CoreException {
        if (this.getElement() instanceof IProject) {
            IProject proj = (IProject)this.getElement();
            proj.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile && ((IFile)res).getFileExtension() != null && ((IFile)res).getFileExtension().equals("cdm")) {
                        try {
                            res.touch(null);
                        }
                        catch (CoreException ex) {
                            logger.severe("Failed to 'touch' CDL file to force re-validation: " + (Object)((Object)ex));
                        }
                    }
                    return true;
                }
            });
        } else {
            ((IResource)this.getElement()).touch(null);
        }
    }
}

