/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.eclipse.Activator;
import org.pi4soa.cdl.eclipse.compare.CDLMergeContentAccessor;
import org.pi4soa.cdl.eclipse.compare.CDLMergeViewer;
import org.pi4soa.common.model.ModelListener;

public class CDLMergeContentProvider
implements IMergeViewerContentProvider {
    private IMergeViewerContentProvider m_provider = null;
    private CDLMergeViewer m_viewer = null;

    public CDLMergeContentProvider(IMergeViewerContentProvider provider, CDLMergeViewer viewer) {
        this.m_provider = provider;
        this.m_viewer = viewer;
    }

    public String getAncestorLabel(Object input) {
        return this.m_provider.getAncestorLabel(input);
    }

    public Image getAncestorImage(Object input) {
        return this.m_provider.getAncestorImage(input);
    }

    public Object getAncestorContent(Object input) {
        return this.m_provider.getAncestorContent(input);
    }

    public boolean showAncestor(Object input) {
        return this.m_provider.showAncestor(input);
    }

    public String getLeftLabel(Object input) {
        return this.m_provider.getLeftLabel(input);
    }

    public Image getLeftImage(Object input) {
        return this.m_provider.getLeftImage(input);
    }

    public Object getLeftContent(Object input) {
        Object ret = this.m_provider.getLeftContent(input);
        if (ret instanceof IStreamContentAccessor) {
            ret = new CDLMergeContentAccessor((IStreamContentAccessor)ret);
        }
        return ret;
    }

    public boolean isLeftEditable(Object input) {
        return this.m_provider.isLeftEditable(input);
    }

    public void saveLeftContent(Object input, byte[] bytes) {
        MergeResult result = this.convertToEMFXMI(bytes);
        boolean f_save = true;
        if (result.getContent() == null) {
            MessageDialog.openError((Shell)this.m_viewer.getShell(), (String)("Unable to save '" + this.getLeftLabel(input) + "'"), (String)result.getMessage());
            if (result.getException() != null) {
                Activator.logError(result.getMessage(), result.getException());
            }
        } else if (result.getMessage() != null) {
            f_save = MessageDialog.openConfirm((Shell)this.m_viewer.getShell(), (String)("Confirm save '" + this.getLeftLabel(input) + "'"), (String)result.getMessage());
        }
        if (f_save) {
            this.m_provider.saveLeftContent(input, result.getContent());
        } else {
            this.m_viewer.setInput(null);
            this.m_viewer.setInput(input);
        }
    }

    public String getRightLabel(Object input) {
        return this.m_provider.getRightLabel(input);
    }

    public Image getRightImage(Object input) {
        return this.m_provider.getRightImage(input);
    }

    public Object getRightContent(Object input) {
        Object ret = this.m_provider.getRightContent(input);
        if (ret instanceof IStreamContentAccessor) {
            ret = new CDLMergeContentAccessor((IStreamContentAccessor)ret);
        }
        return ret;
    }

    public boolean isRightEditable(Object input) {
        return this.m_provider.isRightEditable(input);
    }

    public void saveRightContent(Object input, byte[] bytes) {
        MergeResult result = this.convertToEMFXMI(bytes);
        boolean f_save = true;
        if (result.getContent() == null) {
            MessageDialog.openError((Shell)this.m_viewer.getShell(), (String)("Unable to save '" + this.getRightLabel(input) + "'"), (String)result.getMessage());
            if (result.getException() != null) {
                Activator.logError(result.getMessage(), result.getException());
            }
        } else if (result.getMessage() != null) {
            f_save = MessageDialog.openConfirm((Shell)this.m_viewer.getShell(), (String)("Confirm save '" + this.getRightLabel(input) + "'"), (String)result.getMessage());
        }
        if (f_save) {
            this.m_provider.saveRightContent(input, result.getContent());
        } else {
            this.m_viewer.setInput(null);
            this.m_viewer.setInput(input);
        }
    }

    public void dispose() {
        this.m_provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.m_provider.inputChanged(viewer, oldInput, newInput);
    }

    protected MergeResult convertToEMFXMI(byte[] bytes) {
        MergeResult ret = null;
        try {
            MergeListener listener = new MergeListener();
            Package cdlpack = CDLManager.importFromWSCDL(new ByteArrayInputStream(bytes), (ModelListener)listener);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            CDLManager.save(cdlpack, os);
            ret = new MergeResult(os.toByteArray(), listener.getMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = new MergeResult(null, e.getMessage(), e);
        }
        return ret;
    }

    public class MergeListener
    implements ModelListener {
        private StringBuffer m_message = new StringBuffer();

        public void report(Object source, String mesg, int type) {
            switch (type) {
                case 2: {
                    this.m_message.append("ERROR: ");
                    break;
                }
                case 1: {
                    this.m_message.append("WARNING: ");
                    break;
                }
                case 0: {
                    this.m_message.append("INFO: ");
                }
            }
            this.m_message.append(String.valueOf(mesg) + "\r\n");
        }

        public void report(Object source, String mesg, int reportType, Properties props) {
            this.report(source, mesg, reportType);
        }

        public String getMessage() {
            if (!this.hasMessage()) {
                return null;
            }
            return this.m_message.toString();
        }

        private boolean hasMessage() {
            boolean ret = this.m_message.length() > 0;
            return ret;
        }
    }

    public class MergeResult {
        private byte[] m_content = null;
        private String m_message = null;
        private Throwable m_exception = null;

        public MergeResult(byte[] content, String message, Throwable exception) {
            this.m_content = content;
            this.m_message = message;
            this.m_exception = exception;
        }

        public byte[] getContent() {
            return this.m_content;
        }

        public String getMessage() {
            return this.m_message;
        }

        public Throwable getException() {
            return this.m_exception;
        }
    }
}

