/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CDLMergeContentAccessor
implements IStreamContentAccessor {
    private IStreamContentAccessor m_accessor = null;

    public CDLMergeContentAccessor(IStreamContentAccessor accessor) {
        this.m_accessor = accessor;
    }

    public InputStream getContents() throws CoreException {
        InputStream ret = this.m_accessor.getContents();
        try {
            Package cdlpack = CDLManager.load(ret);
            ModelListener listener = new ModelListener(){

                public void report(Object source, String mesg, int type) {
                    throw new RuntimeException("Failed to load CDL: " + mesg);
                }

                public void report(Object source, String mesg, int type, Properties props) {
                    throw new RuntimeException("Failed to load CDL: " + mesg);
                }
            };
            Document doc = CDLManager.exportToWSCDL(cdlpack, listener);
            String text = XMLUtils.getText((Node)doc, (boolean)true);
            ret = new ByteArrayInputStream(text.getBytes());
        }
        catch (Throwable e) {
            Status status = new Status(4, "org.pi4soa.cdl", 0, "Failed to obtain contents", e);
            throw new CoreException((IStatus)status);
        }
        return ret;
    }
}

