/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.Platform;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;

public class TemplateProcessor {
    private static final String m_baseDir = "templates";
    private static final String PATH_SEPARATOR = "/";
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.eclipse");

    public static String processCDL(Package cdlpack, String templateURI) throws CDLException {
        String ret = null;
        try {
            logger.fine("Process CDL '" + cdlpack + "' with velocity template for URI '" + templateURI + "'");
            File f = new File(templateURI);
            Properties props = new Properties();
            props.put("resource.loader", "file");
            if (!f.isAbsolute()) {
                props.put("file.resource.loader.path", TemplateProcessor.getTemplateBase(f.getParentFile().getPath()));
            } else {
                props.put("file.resource.loader.path", f.getParentFile().getPath());
            }
            templateURI = f.getName();
            props.put("file.resource.loader.cache", "false");
            props.put("file.resource.loader.modificationCheckInterval", "0");
            Velocity.init((Properties)props);
            VelocityContext context = new VelocityContext();
            context.put("package", (Object)cdlpack);
            context.put("choreographies", (Object)TemplateProcessor.getChoreographies(cdlpack));
            Template template = Velocity.getTemplate((String)templateURI);
            logger.fine("Velocity template for URI '" + templateURI + "' is: " + template);
            StringWriter writer = new StringWriter();
            if (template != null) {
                template.merge((Context)context, (Writer)writer);
            }
            writer.flush();
            writer.close();
            ret = writer.toString();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Template output: " + ret);
            }
        }
        catch (Exception e) {
            logger.severe("Failed to apply template: " + e);
            throw new CDLException("Failed to apply template '" + templateURI + "': " + e);
        }
        return ret;
    }

    protected static String getTemplateBase(String relativePath) {
        String ret = null;
        try {
            URL baseurl = Platform.getBundle((String)"org.pi4soa.cdl").getEntry(PATH_SEPARATOR);
            baseurl = Platform.resolve((URL)baseurl);
            String base = baseurl.getFile();
            File f = new File(base);
            base = f.getPath().replace('\\', '/');
            ret = String.valueOf(base) + PATH_SEPARATOR + m_baseDir + PATH_SEPARATOR + relativePath;
            logger.fine("Template base is: " + ret);
        }
        catch (Exception e) {
            logger.severe("Failed to get template URI: " + e);
        }
        return ret;
    }

    protected static List getChoreographies(Package cdlpack) {
        Vector ret = new Vector();
        for (Choreography choreo : cdlpack.getChoreographies()) {
            TemplateProcessor.addChoreographyToList(choreo, ret);
        }
        return ret;
    }

    protected static void addChoreographyToList(Choreography choreo, List list) {
        list.add(choreo);
        for (Choreography sub : choreo.getEnclosedChoreographies()) {
            TemplateProcessor.addChoreographyToList(sub, list);
        }
    }
}

