/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.eclipse.ImportCompletionPage;
import org.pi4soa.cdl.eclipse.WSCDLFileSelectionPage;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.model.ModelListener;
import org.w3c.dom.Document;

public class ImportCDLWizard
extends Wizard
implements IExportWizard {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.eclipse");
    private IContainer m_selection = null;
    private WSCDLFileSelectionPage m_selectionPage = null;
    private ImportCompletionPage m_completionPage = null;
    private String m_importedFileName = null;
    private Package m_package = null;
    private ImportWizardMessageListener m_modelListener = new ImportWizardMessageListener();
    private static String PAGE_NAME1 = "Import Choreography Description From WS-CDL";
    private static String PAGE_NAME2 = "Save Choreography Description Model";
    private static String NO_FOLDER_ERROR = "Resource selected for location of imported CDL was not a folder";
    private static String DEFAULT_FILENAME = "unnamed";

    public boolean performFinish() {
        if (this.m_package != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                CdlPackage.eINSTANCE.getActivity();
                XMIResourceImpl xmi = new XMIResourceImpl();
                xmi.setURI(URI.createURI((String)"test.cdm"));
                xmi.getContents().add((Object)this.m_package);
                xmi.doSave((OutputStream)bos, xmi.getDefaultSaveOptions());
                String filename = String.valueOf(this.processFileName(this.m_package.getName())) + "." + "cdm";
                IFile file = this.m_selection.getFile((IPath)new Path(filename));
                ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                if (!file.exists()) {
                    file.create((InputStream)is, true, null);
                } else {
                    MessageBox box = new MessageBox(this.getShell(), 192);
                    box.setMessage("Overwrite existing Choreography Description '" + filename + "'?");
                    box.setText("WARNING");
                    if (box.open() == 64) {
                        file.setContents((InputStream)is, true, false, null);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to save CDL model", e);
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        String errMesg = null;
        this.m_selectionPage = new WSCDLFileSelectionPage(PAGE_NAME1, "Select an XML file as the source for the imported CDL", false);
        if (selection != null) {
            if (selection.getFirstElement() instanceof IContainer) {
                this.m_selection = (IContainer)selection.getFirstElement();
            } else if (selection.getFirstElement() instanceof IFile && ((IFile)selection.getFirstElement()).getParent() instanceof IContainer) {
                this.m_selection = ((IFile)selection.getFirstElement()).getParent();
            } else {
                errMesg = NO_FOLDER_ERROR;
            }
        } else {
            errMesg = NO_FOLDER_ERROR;
        }
        if (errMesg != null) {
            this.m_selectionPage.setErrorMessage(errMesg);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.m_selectionPage);
        this.m_completionPage = new ImportCompletionPage(PAGE_NAME2, "Save imported CDL model");
        this.addPage((IWizardPage)this.m_completionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage ret = super.getNextPage(page);
        if (page.getName().equals(PAGE_NAME1)) {
            this.importCDL();
        }
        return ret;
    }

    protected void importCDL() {
        if (this.m_importedFileName == null || !this.m_importedFileName.equals(this.m_selectionPage.getFileName())) {
            this.m_completionPage.setPageComplete(false);
            try {
                FileInputStream fis = new FileInputStream(this.m_selectionPage.getFileName());
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                fact.setNamespaceAware(true);
                Document doc = fact.newDocumentBuilder().parse(fis);
                if (doc != null) {
                    this.m_package = CdlFactory.eINSTANCE.createPackage();
                    this.m_modelListener.clearMessages();
                    this.m_package.importFromCDL(doc, this.m_modelListener);
                    this.m_completionPage.showMessages(this.m_modelListener.getErrors(), this.m_modelListener.getWarnings());
                    this.m_importedFileName = this.m_selectionPage.getFileName();
                } else {
                    this.m_completionPage.setErrorMessage("Invalid XML document");
                }
            }
            catch (Exception e) {
                this.m_completionPage.setErrorMessage("Invalid XML document has resulted in exception: " + e);
                logger.log(Level.SEVERE, "Failed to import CDL model", e);
            }
        }
    }

    protected String processFileName(String name) {
        StringBuffer ret = new StringBuffer(name);
        int i = 0;
        while (i < ret.length()) {
            char ch = ret.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                ret.deleteCharAt(i);
                --i;
            }
            ++i;
        }
        if (ret.length() == 0) {
            ret.append(DEFAULT_FILENAME);
        }
        return ret.toString();
    }

    class ImportWizardMessageListener
    implements ModelListener {
        private Vector m_errors = new Vector();
        private Vector m_warnings = new Vector();
        private Vector m_info = new Vector();

        public void report(Object source, String mesg, int reportType) {
            this.report(source, mesg, reportType, null);
        }

        public void report(Object source, String mesg, int reportType, Properties props) {
            String location;
            String text = mesg;
            if (source instanceof CDLType && (location = CDLTypeUtil.getLocation((CDLType)source)) != null) {
                text = String.valueOf(text) + "\r\n\tat " + location;
            }
            if (reportType == 2) {
                this.m_errors.add(text);
            } else if (reportType == 1) {
                this.m_warnings.add(text);
            } else {
                this.m_info.add(text);
            }
        }

        public String[] getErrors() {
            Object[] ret = new String[this.m_errors.size()];
            this.m_errors.copyInto(ret);
            return ret;
        }

        public String[] getWarnings() {
            Object[] ret = new String[this.m_warnings.size()];
            this.m_warnings.copyInto(ret);
            return ret;
        }

        public String[] getInformation() {
            Object[] ret = new String[this.m_info.size()];
            this.m_info.copyInto(ret);
            return ret;
        }

        public void clearMessages() {
            this.m_errors.clear();
            this.m_warnings.clear();
            this.m_info.clear();
        }
    }
}

