/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.eclipse.Activator;
import org.pi4soa.cdl.eclipse.FileSelectionPage;
import org.pi4soa.cdl.eclipse.TemplateProcessor;
import org.pi4soa.cdl.eclipse.VelocityFileSelectionPage;
import org.pi4soa.common.resource.eclipse.ResourceUtil;

public class ExportVelocityWizard
extends Wizard
implements IExportWizard {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.eclipse");
    private IFile m_cdlFile = null;
    private FileSelectionPage m_selectionPage = null;
    private VelocityFileSelectionPage m_velocitySelectionPage = null;
    private static String PAGE_NAME = "Export Choreography Description As HTML";
    private static String VELOCITY_PAGE_NAME = "Choreography Velocity Template";
    private static String RESOURCE_NOT_SELECTED_ERROR = "A resource has not been selected";
    private static String RESOURCE_NOT_FILE_ERROR = "The selected resource is not a file";
    private static String RESOURCE_NOT_CDL_ERROR = "The selected file is not a valid Choreography Description object model";
    private static String RESOURCE_ERROR = "Invalid Choreography Description cannot be exported";

    public boolean performFinish() {
        if (this.m_cdlFile != null) {
            try {
                String generatedText;
                Package cdlpack = Activator.getPackage((IResource)this.m_cdlFile);
                String uri = "html/cdl.vm";
                if (this.m_velocitySelectionPage.getFileName().trim().length() > 0) {
                    uri = this.m_velocitySelectionPage.getFileName();
                }
                if ((generatedText = TemplateProcessor.processCDL(cdlpack, uri)) != null) {
                    FileOutputStream stream = new FileOutputStream(this.m_selectionPage.getFileName());
                    ((OutputStream)stream).write(generatedText.getBytes());
                    ((OutputStream)stream).close();
                } else {
                    logger.warning("No text has been generated for choreography '" + cdlpack.getName() + "' to file '" + this.m_selectionPage.getFileName() + "'");
                }
            }
            catch (Exception e) {
                this.m_selectionPage.setErrorMessage("ERROR: " + e);
                logger.log(Level.SEVERE, "Failed to export CDL model with Velocity template", e);
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        String errMesg = null;
        this.m_selectionPage = new FileSelectionPage(PAGE_NAME, "Select a file as the destination for the CDL based information", true);
        this.m_velocitySelectionPage = new VelocityFileSelectionPage(VELOCITY_PAGE_NAME, "Select the Optional Choreogaphy Velocity Template");
        if (selection != null) {
            if (selection.getFirstElement() instanceof IFile) {
                this.m_cdlFile = (IFile)selection.getFirstElement();
                if (this.m_cdlFile.getFileExtension().equals("cdm")) {
                    if (ResourceUtil.hasErrors((IResource)this.m_cdlFile)) {
                        errMesg = RESOURCE_ERROR;
                    }
                } else {
                    errMesg = RESOURCE_NOT_CDL_ERROR;
                }
            } else {
                errMesg = RESOURCE_NOT_FILE_ERROR;
            }
        } else {
            errMesg = RESOURCE_NOT_SELECTED_ERROR;
        }
        if (errMesg != null) {
            this.m_selectionPage.setErrorMessage(errMesg);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.m_selectionPage);
        this.addPage((IWizardPage)this.m_velocitySelectionPage);
    }
}

