/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.NameSpace;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.impl.CdlPackageImpl;
import org.pi4soa.common.model.Model;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.schema.SchemaManager;
import org.pi4soa.common.schema.SchemaManagerFactory;
import org.pi4soa.common.util.EMFUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.util.PropertyUtil;
import org.pi4soa.common.util.SortUtil;
import org.pi4soa.common.xml.XMLException;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CDLManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl");

    public static Package load(String path) throws IOException {
        InputStream is = null;
        File f = new File(path);
        if (f.exists()) {
            is = new FileInputStream(f);
        } else if (!f.isAbsolute()) {
            is = CDLManager.class.getClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            throw new IOException("Failed to locate path '" + path + "'");
        }
        return CDLManager.load(is, path);
    }

    public static Package load(InputStream is) throws IOException {
        return CDLManager.load(is, null);
    }

    protected static Package load(InputStream is, String url) throws IOException {
        EList list;
        Package ret = null;
        byte[] b = new byte[is.available()];
        is.read(b);
        String xmiText = CDLManager.unexpandXMIReferences(new String(b));
        if (xmiText == null) {
            throw new IOException("Failed to resolve XMI references");
        }
        xmiText = CDLManager.filterChoreographyDescription(xmiText);
        ByteArrayInputStream bais = new ByteArrayInputStream(xmiText.getBytes());
        CdlPackage.eINSTANCE.getPackage();
        CdlPackageImpl.init();
        XMIResourceImpl xmi = new XMIResourceImpl();
        xmi.doLoad((InputStream)bais, xmi.getDefaultLoadOptions());
        if (url != null) {
            xmi.setURI(URI.createFileURI((String)url));
        }
        if ((list = xmi.getContents()).get(0) instanceof Package && (ret = (Package)list.get(0)).eResource().getURI() == null) {
            ret.eResource().setURI(URI.createURI((String)""));
        }
        return ret;
    }

    public static void save(Package pack, OutputStream os) throws IOException {
        CDLManager.save(pack, os, null);
    }

    public static void save(Package pack, OutputStream os, String encoding) throws IOException {
        if (CDLManager.isSortOnSave()) {
            CDLManager.sort(pack);
        }
        CdlPackage.eINSTANCE.getPackage();
        CdlPackageImpl.init();
        pack = (Package)EcoreUtil.copy((EObject)pack);
        EMFUtil.clearDanglingReferences((Object)pack);
        XMIResourceImpl xmi = new XMIResourceImpl();
        xmi.getContents().add((Object)pack);
        if (encoding != null) {
            xmi.setEncoding(encoding);
        }
        OutputStream ostream = os;
        boolean expandRefs = CDLManager.isExpandXMIRefs();
        if (expandRefs) {
            ostream = new ByteArrayOutputStream();
        }
        xmi.doSave(ostream, xmi.getDefaultSaveOptions());
        if (expandRefs) {
            byte[] b = ((ByteArrayOutputStream)ostream).toByteArray();
            String str = new String(b);
            String expanded = CDLManager.expandXMIReferences(pack, str);
            if (expanded != null) {
                os.write(expanded.getBytes());
            } else {
                os.write(b);
                os.flush();
                logger.severe("Failed to expand XMI references - saved in unexpanded form");
            }
        }
    }

    public static Package importFromWSCDL(InputStream is, ModelListener listener) throws XMLException, CDLException {
        Package ret = null;
        Document doc = XMLUtils.loadDocument((InputStream)is);
        if (doc != null) {
            ret = CDLManager.importFromWSCDL(doc, listener);
        }
        return ret;
    }

    public static Package importFromWSCDL(Document doc, ModelListener listener) throws CDLException {
        Package ret = null;
        if (doc != null) {
            ret = CdlFactory.eINSTANCE.createPackage();
            ret.importFromCDL(doc, listener);
        }
        return ret;
    }

    public static Document exportToWSCDL(Package cdlpack, ModelListener listener) throws CDLException {
        Document ret = cdlpack.exportToCDL(listener);
        return ret;
    }

    public static SchemaManager getSchemaManager(CDLType cdlType) {
        SchemaManager ret = SchemaManagerFactory.createSchemaManager();
        if (cdlType != null) {
            int index;
            Resource resource = cdlType.eResource();
            String path = null;
            if (resource != null && resource.getURI() != null && (index = (path = resource.getURI().toFileString()).lastIndexOf(File.separatorChar)) != -1) {
                path = path.substring(0, index);
            }
            Package cdlpack = cdlType.getPackage();
            for (NameSpace ns : cdlpack.getTypeDefinitions().getNameSpaces()) {
                if (!NamesUtil.isSet((String)ns.getSchemaLocation())) continue;
                try {
                    String schemaLocation = ns.getSchemaLocation();
                    File f = new File(schemaLocation);
                    if (!f.isAbsolute()) {
                        schemaLocation = String.valueOf(path) + File.separatorChar + schemaLocation;
                        schemaLocation = URI.createFileURI((String)schemaLocation).toString();
                    }
                    ret.registerSchema(schemaLocation);
                }
                catch (Exception e) {
                    logger.fine("Unable to load schema '" + ns.getSchemaLocation() + "': " + e);
                }
            }
        }
        return ret;
    }

    protected static void sort(Package cdlpack) {
        if (cdlpack != null) {
            if (cdlpack.getTypeDefinitions() != null) {
                SortUtil.sort(cdlpack.getTypeDefinitions().getChannelTypes());
                SortUtil.sort(cdlpack.getTypeDefinitions().getInformationTypes());
                SortUtil.sort(cdlpack.getTypeDefinitions().getParticipantTypes());
                SortUtil.sort(cdlpack.getTypeDefinitions().getRelationshipTypes());
                SortUtil.sort(cdlpack.getTypeDefinitions().getRoleTypes());
                SortUtil.sort(cdlpack.getTypeDefinitions().getTokenLocators());
                SortUtil.sort(cdlpack.getTypeDefinitions().getTokens());
            }
            CDLManager.sortChoreographies(cdlpack.getChoreographies());
        }
    }

    protected static void sortChoreographies(List list) {
        if (list != null) {
            if (list.size() > 1) {
                SortUtil.sort((List)list);
            }
            int i = 0;
            while (i < list.size()) {
                Choreography choreo = (Choreography)list.get(i);
                if (choreo.getVariableDefinitions().size() > 0) {
                    SortUtil.sort(choreo.getVariableDefinitions());
                }
                if (choreo.getEnclosedChoreographies().size() > 0) {
                    CDLManager.sortChoreographies(choreo.getEnclosedChoreographies());
                }
                ++i;
            }
        }
    }

    protected static boolean isSortOnSave() {
        boolean ret = false;
        String prop = PropertyUtil.getProperty((String)"pi4soa.preferences.cdl.sortOnSave");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    protected static boolean isExpandXMIRefs() {
        boolean ret = false;
        String prop = PropertyUtil.getProperty((String)"pi4soa.preferences.cdl.expandXMIRefs");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    public static boolean isVersionSupported(int version) {
        boolean ret = false;
        String prop = PropertyUtil.getProperty((String)"pi4soa.preferences.cdl.version");
        if (prop != null) {
            try {
                int supported = Integer.parseInt(prop);
                if (supported >= version) {
                    ret = true;
                }
            }
            catch (Exception e) {
                logger.warning("Failed to parse pi4soa.preferences.cdl.version '" + prop + "': " + e);
            }
        } else if (version == 1) {
            ret = true;
        }
        return ret;
    }

    public static int getVersion() {
        int ret = 1;
        String prop = PropertyUtil.getProperty((String)"pi4soa.preferences.cdl.version");
        if (prop != null) {
            try {
                ret = Integer.parseInt(prop);
            }
            catch (Exception e) {
                logger.warning("Failed to parse pi4soa.preferences.cdl.version '" + prop + "': " + e);
            }
        }
        return ret;
    }

    public static String expandXMIReferences(Model model, String xmi) {
        StringBuffer ret = new StringBuffer();
        int pos = 0;
        int index = 0;
        while (ret != null && (index = xmi.indexOf("//@", pos)) != -1) {
            ret.append(xmi.substring(pos, index));
            int endIndex = xmi.indexOf(34, index);
            if (endIndex == -1) {
                ret = null;
                logger.severe("Could not find terminating quote at end of reference (position=" + pos + ")");
                continue;
            }
            String xmiRef = xmi.substring(index, endIndex);
            String expandedRef = EMFUtil.convertURIToCanonicalForm((Model)model, (String)xmiRef);
            if (expandedRef == null) {
                ret = null;
                continue;
            }
            ret.append(expandedRef);
            pos = endIndex;
        }
        if (ret != null) {
            ret.append(xmi.substring(pos));
        }
        return ret != null ? ret.toString() : null;
    }

    public static String unexpandXMIReferences(String xmi) {
        StringBuffer ret = new StringBuffer();
        int pos = 0;
        int index = 0;
        Element model = null;
        xmi = xmi.replaceFirst("encoding=\"Cp1252\"", "encoding=\"UTF-8\"");
        xmi = xmi.replaceFirst("encoding=\"MacRoman\"", "encoding=\"UTF-8\"");
        try {
            model = (Element)XMLUtils.getNode((String)xmi);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load XMI document: " + e, e);
            ret = null;
        }
        while (ret != null && (index = xmi.indexOf("REF:", pos)) != -1) {
            if (index > 0 && xmi.charAt(index - 1) == '\"' && xmi.charAt(index + "REF:".length()) == '/') {
                ret.append(xmi.substring(pos, index));
                int endIndex = xmi.indexOf(34, index);
                if (endIndex == -1) {
                    ret = null;
                    logger.severe("Could not find terminating quote at end of reference (position=" + pos + ")");
                    continue;
                }
                String xmiRef = xmi.substring(index, endIndex);
                String unexpandedRef = EMFUtil.convertURIFromCanonicalForm((Element)model, (String)xmiRef);
                if (unexpandedRef == null) {
                    ret = null;
                    continue;
                }
                ret.append(unexpandedRef);
                pos = endIndex;
                continue;
            }
            ret.append(xmi.substring(pos, index + 1));
            pos = index + 1;
        }
        if (ret != null) {
            ret.append(xmi.substring(pos));
        }
        return ret != null ? ret.toString() : null;
    }

    protected static String filterChoreographyDescription(String cdm) {
        String ret = cdm;
        ret = cdm.replaceAll("initiate=\"true\"", "");
        return ret;
    }
}

