/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.util;

import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.xml.sax.Locator;

public class LocatorUtils {
    private LocatorUtils() {
    }

    public static Locator getLocator(Object metadata) {
        if (metadata instanceof Locator) {
            return (Locator)metadata;
        }
        return null;
    }

    public static Locator getLocator(JDefinedClass dc) {
        return dc != null ? LocatorUtils.getLocator(dc.metadata) : null;
    }

    public static Locator getLocator(CClassInfo ci) {
        Locator locator = null;
        if (ci != null && (locator = ci.getLocator()) == null && ci.getSchemaComponent() != null) {
            locator = ci.getSchemaComponent().getLocator();
        }
        return locator;
    }

    public static Locator getLocator(CCustomizable cu) {
        Locator locator = null;
        if (cu != null && (locator = cu.getLocator()) == null && cu.getSchemaComponent() != null) {
            locator = cu.getSchemaComponent().getLocator();
        }
        return locator;
    }

    public static Locator getLocator(ClassOutline co) {
        Locator locator = null;
        if (co.getTarget() != null) {
            locator = LocatorUtils.getLocator(co.getTarget());
        } else if (co.getImplClass() != null) {
            locator = LocatorUtils.getLocator(co.getImplClass());
        }
        return locator;
    }

    public static Locator getLocator(FieldOutline fo) {
        CPropertyInfo fieldInfo;
        Locator locator = null;
        if (fo != null && fo.getPropertyInfo() != null && (locator = (fieldInfo = fo.getPropertyInfo()).getLocator()) == null && fieldInfo.parent() != null) {
            CTypeInfo fieldParent = fieldInfo.parent();
            locator = fieldParent.getSchemaComponent() != null ? fieldParent.getSchemaComponent().getLocator() : fieldParent.getLocator();
        }
        return locator;
    }

    public static Locator getLocator(EnumOutline eo) {
        Locator locator = null;
        if (eo.getTarget() != null) {
            locator = LocatorUtils.getLocator(eo.getTarget());
        } else if (eo.getImplClass() != null) {
            locator = LocatorUtils.getLocator(eo.getImplClass());
        }
        return locator;
    }

    public static Locator getLocator(CPropertyInfo pi) {
        Locator locator = null;
        if (pi != null && (locator = pi.getLocator()) == null) {
            if (pi.getSchemaComponent() != null) {
                locator = pi.getSchemaComponent().getLocator();
            } else if (pi.parent() != null && pi.parent().getLocator() != null) {
                locator = pi.parent().getLocator();
            }
        }
        return locator;
    }

    public static Locator getLocator(CPropertyInfo pi, CClassInfo ci) {
        Locator locator = LocatorUtils.getLocator(pi);
        if (locator == null) {
            locator = LocatorUtils.getLocator(ci);
        }
        return locator;
    }

    public static Locator getLocator(ElementOutline eo) {
        Locator locator = null;
        if (eo != null) {
            if (eo.getTarget() != null) {
                locator = LocatorUtils.getLocator(eo.getTarget());
            } else if (eo.getImplClass() != null) {
                locator = LocatorUtils.getLocator(eo.getImplClass());
            }
        }
        return locator;
    }

    public static Locator getLocator(CPluginCustomization cpc) {
        return cpc != null ? cpc.locator : null;
    }

    public static Locator getLocator(CPluginCustomization cpc, ElementOutline eo) {
        Locator locator = LocatorUtils.getLocator(cpc);
        if (locator == null) {
            locator = LocatorUtils.getLocator(eo);
        }
        return locator;
    }

    public static Locator getLocator(CPluginCustomization cpc, ClassOutline co) {
        Locator locator = LocatorUtils.getLocator(cpc);
        if (locator == null) {
            locator = LocatorUtils.getLocator(co);
        }
        return locator;
    }

    public static Locator getLocator(CPluginCustomization cpc, FieldOutline fo) {
        Locator locator = LocatorUtils.getLocator(cpc);
        if (locator == null) {
            locator = LocatorUtils.getLocator(fo);
        }
        return locator;
    }

    public static Locator getLocator(CPluginCustomization cpc, EnumOutline eo) {
        Locator locator = LocatorUtils.getLocator(cpc);
        if (locator == null) {
            locator = LocatorUtils.getLocator(eo);
        }
        return locator;
    }

    public static String toLocation(Object metadata) {
        return StringUtils.toLocation((Locator)LocatorUtils.getLocator(metadata));
    }

    public static String toLocation(Object metadata, int maxIdSize) {
        return StringUtils.toLocation((Locator)LocatorUtils.getLocator(metadata), (int)maxIdSize);
    }

    public static String toLocation(ClassOutline classOutline) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(classOutline));
    }

    public static String toLocation(CPluginCustomization cpc, ClassOutline co) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(cpc, co));
    }

    public static String toLocation(CPluginCustomization cpc, FieldOutline fo) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(cpc, fo));
    }

    public static String toLocation(CPluginCustomization cpc, EnumOutline eo) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(cpc, eo));
    }

    public static String toLocation(CPluginCustomization cpc) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(cpc));
    }

    public static String toLocation(CClassInfo ci) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(ci));
    }

    public static String toLocation(FieldOutline fieldOutline) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(fieldOutline));
    }

    public static String toLocation(CPropertyInfo pi) {
        return LocatorUtils.toLocation(pi, null);
    }

    public static String toLocation(CPropertyInfo pi, CClassInfo ci) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(pi, ci));
    }

    public static String toLocation(ElementOutline eo) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(eo));
    }

    public static String toLocation(CPluginCustomization cpc, ElementOutline eo) {
        return LocatorUtils.toLocation(LocatorUtils.getLocator(cpc, eo));
    }
}

