/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.reflection.util;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Objects;
import org.jvnet.basicjaxb.reflection.util.Accessor;

public class FieldAccessor<T>
implements Accessor<T> {
    private final Field field;

    public FieldAccessor(Class<?> owner, String fieldName, Class<T> fieldType) {
        try {
            this.field = owner.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not retrieve the field [{0}] from the class [{1}].", fieldName, owner), nsfex);
        }
        catch (SecurityException sex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not retrieve the field [{0}] from the class [{1}].", fieldName, owner), sex);
        }
        if (!fieldType.equals(this.field.getType())) {
            throw new IllegalArgumentException(MessageFormat.format("The field [{0}] does not have the expected type [{1}].", this.field, fieldType));
        }
        try {
            this.field.setAccessible(true);
        }
        catch (SecurityException sex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not make the field [{0}] of the class [{1}] accessible.", this.field, owner), sex);
        }
    }

    @Override
    public T get(Object target) {
        Objects.requireNonNull(target);
        try {
            return (T)this.field.get(target);
        }
        catch (IllegalAccessException iaex) {
            throw new IllegalArgumentException(iaex);
        }
    }

    @Override
    public void set(Object target, T value) {
        Objects.requireNonNull(target);
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException iaex) {
            throw new IllegalArgumentException(iaex);
        }
    }
}

