/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.util;

import java.io.File;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CreateToplevelXJBindings
extends DefaultHandler {
    private static final String DEFAULT_SUFFIX = "Type";
    private static String sourceName = null;
    private static boolean nested = false;
    private static String oldSuffix = "Type";
    private static String newSuffix = "Type";
    private Stack<Tag> tags;

    @Override
    public void startDocument() throws SAXException {
        this.tags = new Stack();
        CreateToplevelXJBindings.println("<jaxb:bindings schemaLocation=\"" + sourceName + "\" node=\"/xs:schema\">");
    }

    @Override
    public void endDocument() throws SAXException {
        CreateToplevelXJBindings.println("</jaxb:bindings>\n");
        this.tags = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        Tag tag = new Tag(localName, attributes);
        if (tag.isRelevant()) {
            this.tags.push(tag);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Tag tag = new Tag(localName);
        if (tag.isRelevant()) {
            if (tag.isComplexType() && (!nested || this.countComplexTypeTags() > 1)) {
                CreateToplevelXJBindings.println("\t<jaxb:bindings node=\"" + this.buildCurrentXPath() + "\">");
                CreateToplevelXJBindings.println("\t\t<jaxb:class name=\"" + this.buildCurrentJavaType() + "\"/>");
                CreateToplevelXJBindings.println("\t</jaxb:bindings>");
            }
            this.tags.pop();
        }
    }

    private int countComplexTypeTags() {
        int count = 0;
        for (Tag tag : this.tags) {
            if (!tag.isComplexType()) continue;
            ++count;
        }
        return count;
    }

    private String buildCurrentXPath() {
        StringBuilder xpath = new StringBuilder();
        xpath.append("/");
        for (Tag tag : this.tags) {
            xpath.append("/xs:" + tag.localName);
            if (tag.nameValue == null) continue;
            xpath = xpath.append("[@name='" + tag.nameValue + "']");
        }
        return xpath.toString();
    }

    private String buildCurrentJavaType() {
        StringBuilder javaType = new StringBuilder();
        for (Tag tag : this.tags) {
            String[] tokens;
            if (tag.nameValue == null) continue;
            for (String token : tokens = tag.nameValue.split("[_-]")) {
                if (token.isEmpty()) continue;
                if (token.endsWith(oldSuffix)) {
                    int offset = token.length() - oldSuffix.length();
                    if (offset <= 0) continue;
                    token = token.substring(0, offset);
                }
                javaType.append(token.substring(0, 1).toUpperCase() + token.substring(1));
            }
        }
        if (!javaType.toString().endsWith(newSuffix)) {
            javaType.append(newSuffix);
        }
        return javaType.toString();
    }

    private static void println(Object obj) {
        if (obj != null) {
            System.out.println(obj.toString());
        }
    }

    private static void errorln(Object obj) {
        if (obj != null) {
            System.err.println(obj.toString());
        }
    }

    private static String parseArg(String arg, String def) {
        String rhs = def;
        String[] nvp = arg.split("=");
        if (nvp.length > 1) {
            rhs = nvp[1].trim();
        }
        return rhs;
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                sourceName = arg;
                continue;
            }
            if (arg.startsWith("--nested")) {
                nested = new Boolean(CreateToplevelXJBindings.parseArg(arg, "true"));
                continue;
            }
            if (arg.startsWith("--oldSuffix")) {
                oldSuffix = CreateToplevelXJBindings.parseArg(arg, DEFAULT_SUFFIX);
                continue;
            }
            if (!arg.startsWith("--newSuffix")) continue;
            newSuffix = CreateToplevelXJBindings.parseArg(arg, DEFAULT_SUFFIX);
        }
        if (sourceName != null) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(new CreateToplevelXJBindings());
            String path = new File(sourceName).getAbsolutePath();
            xmlReader.parse("file:" + path);
            System.exit(0);
        } else {
            CreateToplevelXJBindings.errorln("Usage: CreateToplevelXJBindings [--nested] [--oldSuffix=somename] [--newSuffix=somename] <file.xml>");
            System.exit(1);
        }
    }

    private static class Tag {
        public String localName;
        public String nameValue;

        public Tag(String localName, String nameValue) {
            this.localName = localName;
            this.nameValue = nameValue;
        }

        public Tag(String localName) {
            this(localName, (String)null);
        }

        public Tag(String localName, Attributes attributes) {
            this(localName, Tag.nameValue(attributes));
        }

        public String toString() {
            return "Tag[" + this.localName + ", " + this.nameValue + "]";
        }

        private boolean isRelevant() {
            boolean isRelevant = false;
            switch (this.localName) {
                case "element": 
                case "complexType": 
                case "sequence": 
                case "choice": 
                case "complexContent": 
                case "extension": {
                    isRelevant = true;
                    break;
                }
                default: {
                    isRelevant = false;
                }
            }
            return isRelevant;
        }

        private boolean isComplexType() {
            return "complexType".equals(this.localName);
        }

        private static String nameValue(Attributes attributes) {
            String nameValue = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrVal = attributes.getValue(i);
                if (!"name".equals(attrName)) continue;
                nameValue = attrVal;
                break;
            }
            return nameValue;
        }
    }
}

