/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JNullType;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.jvnet.basicjaxb.codemodel.JCMArrayClass;
import org.jvnet.basicjaxb.codemodel.JCMClass;
import org.jvnet.basicjaxb.codemodel.JCMNullType;
import org.jvnet.basicjaxb.codemodel.JCMPrimitiveType;
import org.jvnet.basicjaxb.codemodel.JCMType;
import org.jvnet.basicjaxb.codemodel.JCMTypeVar;
import org.jvnet.basicjaxb.codemodel.JCMTypeWildcard;

public class JCMTypeFactory {
    public static final JCMTypeFactory INSTANCE = new JCMTypeFactory();

    public <JT extends JType> JCMType<JT> create(JT type) {
        Validate.notNull(type);
        if (type.isArray()) {
            Validate.isInstanceOf(JClass.class, type);
            JCMArrayClass result = new JCMArrayClass(this, (JClass)type);
            return result;
        }
        if (type instanceof JTypeVar) {
            JCMTypeVar result = new JCMTypeVar(this, (JTypeVar)type);
            return result;
        }
        if (type instanceof JNullType) {
            JCMNullType result = new JCMNullType(this, (JNullType)type);
            return result;
        }
        if ("com.sun.codemodel.JTypeWildcard".equals(type.getClass().getName())) {
            JCMTypeWildcard result = new JCMTypeWildcard(this, (JClass)type);
            return result;
        }
        if (type instanceof JClass) {
            JCMClass result = new JCMClass(this, (JClass)type);
            return result;
        }
        if (type instanceof JPrimitiveType) {
            JCMPrimitiveType result = new JCMPrimitiveType(this, (JPrimitiveType)type);
            return result;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unsupported type [{0}].", type.toString()));
    }
}

