/*
 * Decompiled with CFR 0.152.
 */
package org.patrodyne.jvnet.basicjaxb.explore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.patrodyne.jvnet.basicjaxb.explore.ConsoleWriter;
import org.patrodyne.jvnet.basicjaxb.explore.HtmlPane;

public abstract class AbstractExplorer
extends JFrame {
    protected static String CONSOLE_FONT_POINTS = "ConsoleFontPoints";
    protected static String DEFAULT_CONSOLE_FONT_POINTS = "14";
    protected static String WINDOW_LEFT = "WindowLeft";
    protected static String WINDOW_TOP = "WindowTop";
    protected static String WINDOW_WIDTH = "WindowWidth";
    protected static String WINDOW_HEIGHT = "WindowHeight";
    protected static String DEFAULT_WINDOW_LEFT = "100";
    protected static String DEFAULT_WINDOW_TOP = "100";
    protected static String DEFAULT_WINDOW_WIDTH = "960";
    protected static String DEFAULT_WINDOW_HEIGHT = "512";
    protected static double CONFIG_EXPLORE_PANE_WEIGHT = 0.4;
    protected static double CONFIG_STREAM_PANE_WEIGHT = 0.75;
    protected static Charset CONFIG_CHARSET = Charset.defaultCharset();
    protected static final String OILPATH = "open-icon-library/24x24";
    private JSplitPane streamPane;
    private JSplitPane lessonPane;
    private JToolBar toolBar;
    private ConsoleWriter consoleWriter;
    private ConsoleWriter errorWriter;
    private PrintStream printStream = System.out;
    private PrintStream errorStream = System.err;

    public JSplitPane getStreamPane() {
        return this.streamPane;
    }

    public void setStreamPane(JSplitPane streamPane) {
        this.streamPane = streamPane;
    }

    public JSplitPane getLessonPane() {
        return this.lessonPane;
    }

    public void setLessonPane(JSplitPane lessonPane) {
        this.lessonPane = lessonPane;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public HtmlPane getHtmlPane() {
        JViewport htmlViewPort = ((JScrollPane)this.getLessonPane().getLeftComponent()).getViewport();
        return (HtmlPane)htmlViewPort.getView();
    }

    protected static void printStackTrace(Throwable ex) {
        ex.printStackTrace();
    }

    public ConsoleWriter getConsoleWriter() {
        return this.consoleWriter;
    }

    public void setConsoleWriter(ConsoleWriter consoleWriter) {
        this.consoleWriter = consoleWriter;
    }

    public ConsoleWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(ConsoleWriter errorWriter) {
        this.errorWriter = errorWriter;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
        System.setOut(printStream);
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
        System.setErr(errorStream);
    }

    public void println() {
        this.println("");
    }

    public void println(Object obj) {
        if (obj != null) {
            if (this.getConsoleWriter() != null) {
                try {
                    this.getConsoleWriter().write(obj.toString() + "\n");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.getPrintStream().println(obj.toString());
            }
            this.getPrintStream().flush();
        }
    }

    public void println(Object[] objs) {
        if (objs != null) {
            for (Object obj : objs) {
                this.println(obj);
            }
        }
    }

    public void errorln(Object obj) {
        if (obj != null) {
            if (this.getErrorWriter() != null) {
                try {
                    this.getErrorWriter().write(obj.toString() + "\n");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.getErrorStream().println(obj.toString());
            }
            this.getErrorStream().flush();
        }
    }

    public void errorln(Exception ex) {
        if (ex != null) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.errorln(sw.toString());
        }
    }

    public void errorDialog(String title, Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        JTextArea jta = new JTextArea(sw.toString());
        jta.setTabSize(this.getErrorWriter().getTextArea().getTabSize());
        jta.setFont(this.getErrorWriter().getTextArea().getFont());
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setPreferredSize(this.half(this.getSize()));
        JOptionPane.showMessageDialog(null, jsp, title, 0);
    }

    private Dimension half(Dimension dim) {
        Double hgt = dim.getHeight() / 2.0;
        Double wth = dim.getWidth() / 2.0;
        hgt.intValue();
        return new Dimension(wth.intValue(), hgt.intValue());
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            this.errorln(ex);
        }
    }

    public String ns(long nt1, long nt2) {
        return NumberFormat.getIntegerInstance().format(nt2 - nt1) + " ns";
    }

    public String getResourceAsString(Class<?> clazz, String resourceName) {
        StringBuilder html = new StringBuilder();
        try (InputStream htmlStream = clazz.getResourceAsStream(resourceName);){
            if (htmlStream != null) {
                html.append(IOUtils.toString((InputStream)htmlStream, (Charset)StandardCharsets.UTF_8));
            } else {
                this.errorln("ERROR: Resource not found, " + resourceName + ".");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return html.toString();
    }

    private Preferences getPreferences() {
        return Preferences.userNodeForPackage(this.getClass());
    }

    private void createLayout(String htmlName) {
        this.setToolBar(this.createToolBar());
        JPanel contentPanel = this.createContentPanel(htmlName);
        this.add((Component)this.getToolBar(), "West");
        this.add((Component)contentPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences prefs = AbstractExplorer.this.getPreferences();
                prefs.put(WINDOW_LEFT, this.round(AbstractExplorer.this.getLocation().getX()));
                prefs.put(WINDOW_TOP, this.round(AbstractExplorer.this.getLocation().getY()));
                prefs.put(WINDOW_WIDTH, this.round(AbstractExplorer.this.getSize().getWidth()));
                prefs.put(WINDOW_HEIGHT, this.round(AbstractExplorer.this.getSize().getHeight()));
                prefs.put(CONSOLE_FONT_POINTS, this.points(AbstractExplorer.this.getConsoleWriter().getTextArea()));
            }

            private String round(double value) {
                return String.format("%.0f", value);
            }

            private String points(JTextArea textArea) {
                return Integer.toString(textArea.getFont().getSize());
            }
        });
        this.addHyperlinkDispatcher();
        this.setDefaultCloseOperation(3);
    }

    private void addHyperlinkDispatcher() {
        this.getHtmlPane().addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().startsWith("!")) {
                this.dispatchHyperLink(event.getDescription().substring(1));
            }
        });
    }

    public void dispatchHyperLink(String hyperLink) {
    }

    private JToolBar createToolBar() {
        JButton clearButton = this.createImageButton(AbstractExplorer.class, "open-icon-library/24x24/actions/edit-clear.png");
        clearButton.setToolTipText("Clear output panels.");
        clearButton.addActionListener(ae -> {
            this.getConsoleWriter().clear();
            this.getErrorWriter().clear();
        });
        JButton zoomInButton = this.createImageButton(AbstractExplorer.class, "open-icon-library/24x24/actions/zoom-in-3.png");
        zoomInButton.setToolTipText("Larger text size.");
        zoomInButton.addActionListener(ae -> {
            this.getConsoleWriter().largerText();
            this.getErrorWriter().largerText();
        });
        JButton zoomOutButton = this.createImageButton(AbstractExplorer.class, "open-icon-library/24x24/actions/zoom-out-3.png");
        zoomOutButton.setToolTipText("Smaller text size.");
        zoomOutButton.addActionListener(ae -> {
            this.getConsoleWriter().smallerText();
            this.getErrorWriter().smallerText();
        });
        JToolBar toolBar = new JToolBar(1);
        toolBar.add(clearButton);
        toolBar.add(zoomInButton);
        toolBar.add(zoomOutButton);
        return toolBar;
    }

    protected ImageIcon createImageIcon(Class<?> clazz, String path) {
        return new ImageIcon(clazz.getResource(path));
    }

    protected JButton createImageButton(Class<?> clazz, String path) {
        return new JButton(this.createImageIcon(clazz, path));
    }

    protected JToggleButton createImageToggleButton(Class<?> clazz, String iconPath1, String iconPath2) {
        JToggleButton toggleButton = new JToggleButton(this.createImageIcon(clazz, iconPath1));
        toggleButton.setSelectedIcon(this.createImageIcon(clazz, iconPath2));
        return toggleButton;
    }

    private JPanel createContentPanel(String htmlName) {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        Integer fontPoints = Integer.valueOf(this.getPreferences().get(CONSOLE_FONT_POINTS, DEFAULT_CONSOLE_FONT_POINTS));
        this.setConsoleWriter(new ConsoleWriter(fontPoints));
        this.setPrintStream(this.createPrintStream(this.getConsoleWriter()));
        JScrollPane consolePane = new JScrollPane(this.getConsoleWriter().getTextArea());
        this.setErrorWriter(new ConsoleWriter(fontPoints));
        this.setErrorStream(this.createPrintStream(this.getErrorWriter()));
        JScrollPane errorPane = new JScrollPane(this.getErrorWriter().getTextArea());
        JSplitPane streamPane = new JSplitPane(0, consolePane, errorPane);
        streamPane.setOneTouchExpandable(true);
        streamPane.setResizeWeight(CONFIG_STREAM_PANE_WEIGHT);
        this.setStreamPane(streamPane);
        String html = this.getResourceAsString(this.getClass(), htmlName);
        JScrollPane htmlPane = new JScrollPane(new HtmlPane(html));
        JSplitPane lessonPane = new JSplitPane(1, htmlPane, streamPane);
        lessonPane.setOneTouchExpandable(true);
        lessonPane.setResizeWeight(CONFIG_EXPLORE_PANE_WEIGHT);
        this.setLessonPane(lessonPane);
        contentPanel.add(lessonPane);
        return contentPanel;
    }

    private PrintStream createPrintStream(Writer writer) {
        PrintStream printStream = System.err;
        try {
            WriterOutputStream.Builder wosBuilder = WriterOutputStream.builder();
            wosBuilder.setCharset(CONFIG_CHARSET);
            wosBuilder.setWriter(writer);
            printStream = new PrintStream((OutputStream)wosBuilder.get());
        }
        catch (IOException ex) {
            this.errorln(ex);
        }
        return printStream;
    }

    public AbstractExplorer(String htmlName) {
        Thread.setDefaultUncaughtExceptionHandler(new ErrorHandler());
        this.createLayout(htmlName);
        this.pack();
        Preferences prefs = this.getPreferences();
        this.setSize(Integer.valueOf(prefs.get(WINDOW_WIDTH, DEFAULT_WINDOW_WIDTH)), Integer.valueOf(prefs.get(WINDOW_HEIGHT, DEFAULT_WINDOW_HEIGHT)));
        this.setLocation(Integer.valueOf(prefs.get(WINDOW_LEFT, DEFAULT_WINDOW_LEFT)), Integer.valueOf(prefs.get(WINDOW_TOP, DEFAULT_WINDOW_TOP)));
        this.setVisible(true);
        this.getLessonPane().setDividerLocation(CONFIG_EXPLORE_PANE_WEIGHT);
        this.getStreamPane().setDividerLocation(CONFIG_STREAM_PANE_WEIGHT);
        this.getHtmlPane().requestFocus();
    }

    protected static final class ErrorHandler
    implements Thread.UncaughtExceptionHandler {
        protected ErrorHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable ex) {
            AbstractExplorer.printStackTrace(ex);
        }
    }
}

