/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.xml.bind.annotation.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.basicjaxb.lang.StringUtils;

public class CommaDelimitedStringAdapter
extends XmlAdapter<String, List<String>> {
    public String marshal(List<String> value) throws Exception {
        if (value == null) {
            return null;
        }
        return StringUtils.join(value.iterator(), ", ");
    }

    public List<String> unmarshal(String text) throws Exception {
        String[] items;
        if (text == null) {
            return null;
        }
        LinkedList<String> value = new LinkedList<String>();
        for (String item : items = StringUtils.split(text, ',')) {
            String trimmedItem = item.trim();
            if (StringUtils.isEmpty(trimmedItem)) continue;
            value.add(trimmedItem);
        }
        return value;
    }
}

