/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jvnet.basicjaxb.lang.StringUtils;

public class ValueUtils {
    public static final String REGEX_SPACES = "\\s+";
    public static final HexBinaryAdapter HEX_BINARY_ADAPTER = new HexBinaryAdapter();
    public static final DatatypeFactory DATATYPE_FACTORY;

    public static List<BigDecimal> toBigDecimalList(String valueList) {
        return ValueUtils.toBigDecimalList(valueList, REGEX_SPACES);
    }

    public static List<BigDecimal> toBigDecimalList(String valueList, String regex) {
        ArrayList<BigDecimal> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<BigDecimal>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toBigDecimal(value));
            }
        }
        return list;
    }

    public static BigDecimal toBigDecimal(String value) {
        return new BigDecimal(value);
    }

    public static List<BigInteger> toBigIntegerList(String valueList) {
        return ValueUtils.toBigIntegerList(valueList, REGEX_SPACES);
    }

    public static List<BigInteger> toBigIntegerList(String valueList, String regex) {
        ArrayList<BigInteger> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<BigInteger>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toBigInteger(value));
            }
        }
        return list;
    }

    public static BigInteger toBigInteger(String value) {
        return new BigInteger(value);
    }

    public static List<Boolean> toBooleanList(String valueList) {
        return ValueUtils.toBooleanList(valueList, REGEX_SPACES);
    }

    public static List<Boolean> toBooleanList(String valueList, String regex) {
        ArrayList<Boolean> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Boolean>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toBoolean(value));
            }
        }
        return list;
    }

    public static Boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static List<Byte> toByteList(String valueList) {
        return ValueUtils.toByteList(valueList, REGEX_SPACES);
    }

    public static List<Byte> toByteList(String valueList, String regex) {
        ArrayList<Byte> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Byte>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toByte(value));
            }
        }
        return list;
    }

    public static Byte toByte(String value) {
        return Byte.valueOf(value);
    }

    public static byte[] parseBase64Binary(String value) {
        return DatatypeConverter.parseBase64Binary((String)value);
    }

    public static byte[] parseHexBinary(String value) {
        return HEX_BINARY_ADAPTER.unmarshal(value);
    }

    public static List<Double> toDoubleList(String valueList) {
        return ValueUtils.toDoubleList(valueList, REGEX_SPACES);
    }

    public static List<Double> toDoubleList(String valueList, String regex) {
        ArrayList<Double> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Double>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toDouble(value));
            }
        }
        return list;
    }

    public static Double toDouble(String value) {
        switch (value) {
            case "INF": {
                return Double.POSITIVE_INFINITY;
            }
            case "-INF": {
                return Double.NEGATIVE_INFINITY;
            }
            case "NaN": {
                return Double.NaN;
            }
        }
        return Double.valueOf(value);
    }

    public static List<Duration> toDurationList(String valueList) {
        return ValueUtils.toDurationList(valueList, REGEX_SPACES);
    }

    public static List<Duration> toDurationList(String valueList, String regex) {
        ArrayList<Duration> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Duration>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toDuration(value));
            }
        }
        return list;
    }

    public static Duration toDuration(String value) {
        return DATATYPE_FACTORY.newDuration(value);
    }

    public static List<Float> toFloatList(String valueList) {
        return ValueUtils.toFloatList(valueList, REGEX_SPACES);
    }

    public static List<Float> toFloatList(String valueList, String regex) {
        ArrayList<Float> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Float>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toFloat(value));
            }
        }
        return list;
    }

    public static Float toFloat(String value) {
        switch (value) {
            case "INF": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "-INF": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            case "NaN": {
                return Float.valueOf(Float.NaN);
            }
        }
        return Float.valueOf(value);
    }

    public static List<Integer> toIntegerList(String valueList) {
        return ValueUtils.toIntegerList(valueList, REGEX_SPACES);
    }

    public static List<Integer> toIntegerList(String valueList, String regex) {
        ArrayList<Integer> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Integer>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toInteger(value));
            }
        }
        return list;
    }

    public static Integer toInteger(String value) {
        return Integer.valueOf(value);
    }

    public static List<Long> toLongList(String valueList) {
        return ValueUtils.toLongList(valueList, REGEX_SPACES);
    }

    public static List<Long> toLongList(String valueList, String regex) {
        ArrayList<Long> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Long>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toLong(value));
            }
        }
        return list;
    }

    public static Long toLong(String value) {
        return Long.valueOf(value);
    }

    public static List<Short> toShortList(String valueList) {
        return ValueUtils.toShortList(valueList, REGEX_SPACES);
    }

    public static List<Short> toShortList(String valueList, String regex) {
        ArrayList<Short> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<Short>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toShort(value));
            }
        }
        return list;
    }

    public static Short toShort(String value) {
        return Short.valueOf(value);
    }

    public static List<String> toStringList(String valueList) {
        return ValueUtils.toStringList(valueList, REGEX_SPACES);
    }

    public static List<String> toStringList(String valueList, String regex) {
        List<String> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = Arrays.asList(values);
        }
        return list;
    }

    public static String toString(String value) {
        return value;
    }

    public static List<XMLGregorianCalendar> toXMLGregorianCalendarList(String valueList) {
        return ValueUtils.toXMLGregorianCalendarList(valueList, REGEX_SPACES);
    }

    public static List<XMLGregorianCalendar> toXMLGregorianCalendarList(String valueList, String regex) {
        ArrayList<XMLGregorianCalendar> list = null;
        if (!StringUtils.isBlank(valueList)) {
            String[] values = valueList.split(regex);
            list = new ArrayList<XMLGregorianCalendar>(values.length);
            for (String value : values) {
                list.add(ValueUtils.toXMLGregorianCalendar(value));
            }
        }
        return list;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(String value) {
        return DATATYPE_FACTORY.newXMLGregorianCalendar(value);
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException("Unable to initialize DatatypeFactory", ex);
        }
    }
}

