/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.hashcode;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.HashCode;
import org.jvnet.basicjaxb.lang.HashCodeStrategy;
import org.jvnet.basicjaxb.lang.JAXBHashCodeStrategy;
import org.jvnet.basicjaxb.locator.DefaultRootObjectLocator;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.FieldOutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class HashCodePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XhashCode";
    private static final String OPTION_DESC = "generate reflection-free 'hashCode' methods";
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String hashCodeStrategyClass = JAXBHashCodeStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.hashcode.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public String getHashCodeStrategyClass() {
        return this.hashCodeStrategyClass;
    }

    public void setHashCodeStrategyClass(String hashCodeStrategy) {
        this.hashCodeStrategyClass = hashCodeStrategy;
    }

    public JExpression createHashCodeStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, HashCodeStrategy.class, this.getHashCodeStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.hashcode.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  HashCodeStrategyClass.: " + this.getHashCodeStrategyClass());
            sb.append("\n  Verbose...............: " + this.isVerbose());
            sb.append("\n  Debug.................: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(HashCode.class));
        JMethod hashCode$hashCode = this.generateHashCode$hashCode(classOutline, theClass);
        JMethod object$hashCode = this.generateObject$hashCode(classOutline, theClass);
    }

    protected JMethod generateObject$hashCode(ClassOutline classOutline, JDefinedClass theClass) {
        return this.generateObject$hashCode(theClass);
    }

    private JMethod generateObject$hashCode(JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod object$hashCode = theClass.method(1, (JType)theClass.owner().INT, "hashCode");
        object$hashCode.annotate(Override.class);
        JBlock body = object$hashCode.body();
        JVar theLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "theLocator", JExpr._null());
        JVar hashCodeStrategy = body.decl(8, (JType)theClass.owner().ref(HashCodeStrategy.class), "strategy", this.createHashCodeStrategy(theClass.owner()));
        JInvocation theRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg(JExpr._this());
        JConditional ifDebugEnabled = body._if((JExpression)hashCodeStrategy.invoke("isDebugEnabled"));
        ifDebugEnabled._then().assign((JAssignmentTarget)theLocator, (JExpression)theRootLocator);
        body._return((JExpression)JExpr._this().invoke("hashCode").arg((JExpression)theLocator).arg((JExpression)hashCodeStrategy));
        this.debug("{}, generateObject$hashCode; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return object$hashCode;
    }

    protected JMethod generateHashCode$hashCode(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod hashCode$hashCode = theClass.method(1, (JType)codeModel.INT, "hashCode");
        hashCode$hashCode.annotate(Override.class);
        JVar locator = hashCode$hashCode.param(ObjectLocator.class, "locator");
        JVar hashCodeStrategy = hashCode$hashCode.param(HashCodeStrategy.class, "strategy");
        JBlock body = hashCode$hashCode.body();
        Boolean superClassImplementsHashCode = StrategyClassUtils.superClassImplements(classOutline, this.ignoring, HashCode.class);
        Object currentHashCodeExpression = superClassImplementsHashCode == null ? JExpr.lit((int)1) : (superClassImplementsHashCode != false ? JExpr._super().invoke("hashCode").arg((JExpression)locator).arg((JExpression)hashCodeStrategy) : JExpr._super().invoke("hashCode"));
        JVar currentHashCode = body.decl((JType)codeModel.INT, "currentHashCode", currentHashCodeExpression);
        for (FieldOutline fieldOutline : declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
            if (fieldAccessor.isConstant()) continue;
            JBlock block = body.block();
            JExpression theFieldIsSetEx = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
            JVar theFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "theFieldIsSet", theFieldIsSetEx);
            JVar theField = block.decl(fieldAccessor.getType(), this.fieldName("the"));
            fieldAccessor.toRawValue(block, theField);
            String fieldName = this.fieldName(fieldOutline);
            JInvocation theFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)locator).arg(fieldName).arg((JExpression)theField);
            JVar theFieldLocator = block.decl(locator.type(), "theFieldLocator", (JExpression)theFieldLocatorEx);
            block.assign((JAssignmentTarget)currentHashCode, (JExpression)hashCodeStrategy.invoke("hashCode").arg((JExpression)theFieldLocator).arg((JExpression)currentHashCode).arg((JExpression)theField).arg((JExpression)theFieldIsSet));
            this.trace("{}, generateHashCode$hashCode; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Object)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldName});
        }
        body._return((JExpression)currentHashCode);
        return hashCode$hashCode;
    }

    private String fieldName(FieldOutline fieldOutline) {
        return fieldOutline.getPropertyInfo().getName(false);
    }

    private String fieldName(String prefix) {
        return prefix + "Field";
    }

    private String fieldName(String prefix, FieldOutline fieldOutline) {
        return this.fieldName(prefix) + fieldOutline.getPropertyInfo().getName(true);
    }
}

