/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.fluentapi;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.List;
import org.jvnet.basicjaxb.plugin.fluentapi.FluentMethodInfo;
import org.jvnet.basicjaxb.util.CodeModelUtils;

public enum FluentMethodType {
    FLUENT_SETTER{

        @Override
        public void createFluentMethod(JDefinedClass implClass, FluentMethodInfo fluentMethodInfo) {
            JMethod setterMethod = fluentMethodInfo.getOriginalMethod();
            String setterName = setterMethod.name();
            String fluentName = FluentMethodType.FLUENT_SETTER_METHOD_PREFIX + setterName.substring(SETTER_METHOD_PREFIX_LEN);
            int mods = 1 | setterMethod.mods().getValue() & 8;
            JMethod fluentMethod = implClass.method(mods, (JType)implClass, fluentName);
            CodeModelUtils.groupMethods((JDefinedClass)implClass, (JMethod)setterMethod, (JMethod)fluentMethod);
            if (fluentMethodInfo.isOverride()) {
                fluentMethod.annotate(Override.class);
            }
            JVar[] jvars = setterMethod.listParams();
            assert (jvars.length == 1 || jvars.length == 2);
            for (JVar jvar : jvars) {
                fluentMethod.param(jvar.mods().getValue(), jvar.type(), jvar.name());
            }
            JBlock jblock = fluentMethod.body();
            JInvocation jinvocation = jblock.invoke(setterMethod);
            for (JVar jvar : jvars) {
                jinvocation.arg((JExpression)jvar);
            }
            jblock._return(JExpr._this());
        }
    }
    ,
    FLUENT_LIST_SETTER{

        @Override
        public void createFluentMethod(JDefinedClass implClass, FluentMethodInfo fluentMethodInfo) {
            JMethod listGetterMethod = fluentMethodInfo.getOriginalMethod();
            String listGetterName = listGetterMethod.name();
            String fluentName = FluentMethodType.FLUENT_SETTER_METHOD_PREFIX + listGetterName.substring(GETTER_METHOD_PREFIX_LEN);
            int mods = 1 | listGetterMethod.mods().getValue() & 8;
            JMethod fluentMethod = implClass.method(mods, (JType)implClass, fluentName);
            CodeModelUtils.groupMethods((JDefinedClass)implClass, (JMethod)listGetterMethod, (JMethod)fluentMethod);
            if (fluentMethodInfo.isOverride()) {
                fluentMethod.annotate(Override.class);
            }
            JType returnJType = listGetterMethod.type();
            JClass returnJClass = (JClass)JClass.class.cast(returnJType);
            List typeParams = returnJClass.getTypeParameters();
            assert (typeParams.size() == 1);
            JClass typeParam = (JClass)typeParams.get(0);
            JVar jvarParam = fluentMethod.varParam((JType)typeParam, FluentMethodType.VALUES);
            JBlock body = fluentMethod.body();
            JConditional cond = body._if(jvarParam.ne(JExpr._null()));
            JForEach forEach = cond._then().forEach((JType)typeParam, FluentMethodType.VALUE, (JExpression)JExpr.ref((String)FluentMethodType.VALUES));
            JInvocation addInvocation = forEach.body().invoke((JExpression)JExpr.invoke((JMethod)listGetterMethod), "add");
            addInvocation.arg((JExpression)JExpr.ref((String)FluentMethodType.VALUE));
            body._return(JExpr._this());
        }
    }
    ,
    FLUENT_COLLECTION_SETTER{

        @Override
        public void createFluentMethod(JDefinedClass implClass, FluentMethodInfo fluentMethodInfo) {
            JMethod listGetterMethod = fluentMethodInfo.getOriginalMethod();
            String listGetterName = listGetterMethod.name();
            String fluentName = FluentMethodType.FLUENT_SETTER_METHOD_PREFIX + listGetterName.substring(GETTER_METHOD_PREFIX_LEN);
            int mods = 1 | listGetterMethod.mods().getValue() & 8;
            JMethod fluentMethod = implClass.method(mods, (JType)implClass, fluentName);
            CodeModelUtils.groupMethods((JDefinedClass)implClass, (JMethod)listGetterMethod, (JMethod)fluentMethod);
            if (fluentMethodInfo.isOverride()) {
                fluentMethod.annotate(Override.class);
            }
            JType returnJType = listGetterMethod.type();
            JClass returnJClass = (JClass)JClass.class.cast(returnJType);
            List typeParams = returnJClass.getTypeParameters();
            assert (typeParams.size() == 1);
            JClass typeParam = (JClass)typeParams.get(0);
            JClass narrowedCollectionJClass = implClass.owner().ref(Collection.class).narrow(typeParam);
            JVar jvarParam = fluentMethod.param((JType)narrowedCollectionJClass, FluentMethodType.VALUES);
            JBlock body = fluentMethod.body();
            JConditional cond = body._if(jvarParam.ne(JExpr._null()));
            JInvocation addInvocation = cond._then().invoke((JExpression)JExpr.invoke((JMethod)listGetterMethod), "addAll");
            addInvocation.arg((JExpression)jvarParam);
            body._return(JExpr._this());
        }
    };

    private static final String VALUE = "value";
    private static final String VALUES = "values";
    public static final String GETTER_METHOD_PREFIX = "get";
    public static final String SETTER_METHOD_PREFIX = "set";
    public static final String FLUENT_SETTER_METHOD_PREFIX = "use";
    public static final String PARAMETERIZED_LIST_PREFIX;
    public static final int SETTER_METHOD_PREFIX_LEN;
    public static final int GETTER_METHOD_PREFIX_LEN;

    public abstract void createFluentMethod(JDefinedClass var1, FluentMethodInfo var2);

    static {
        PARAMETERIZED_LIST_PREFIX = List.class.getName() + "<";
        SETTER_METHOD_PREFIX_LEN = SETTER_METHOD_PREFIX.length();
        GETTER_METHOD_PREFIX_LEN = GETTER_METHOD_PREFIX.length();
    }
}

