/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.enumvalue;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.EnumValue;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class EnumValuePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XenumValue";
    private static final String OPTION_DESC = "generated @XmlEnums implement generic EnumValue<T> interface";
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (EnumOutline enumOutline : outline.getEnums()) {
            if (this.getIgnoring().isIgnored(enumOutline)) continue;
            this.processEnumOutline(enumOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processEnumOutline(EnumOutline enumOutline) {
        CEnumLeafInfo enumLeafInfo = enumOutline.target;
        JClass enumType = enumLeafInfo.base.toType(enumOutline.parent(), Aspect.EXPOSED).boxify();
        JDefinedClass theClass = enumOutline.clazz;
        ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(EnumValue.class).narrow(enumType));
        JMethod enumValue$enumValue = theClass.method(1, (JType)enumType, "enumValue");
        enumValue$enumValue.annotate(Override.class);
        enumValue$enumValue.body()._return((JExpression)JExpr._this().invoke("value"));
        if (this.isDebugEnabled()) {
            String location = StringUtils.toLocation((Locator)enumLeafInfo.getLocator());
            QName typeName = enumLeafInfo.getTypeName();
            JDefinedClass implClass = enumOutline.getImplClass();
            this.debug("{}, TypeName={}, ImplName={}", new Object[]{location, typeName, implClass.name()});
        }
    }
}

