/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.s3;

import com.google.common.net.MediaType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class SAML2S3MetadataGenerator
extends BaseSAML2MetadataGenerator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2S3MetadataGenerator.class);
    static final String BUCKET_NAME_PREFIX = "pac4j-saml-metadata";
    private final S3Client s3Client;
    private final String entityId;
    private boolean createBucketIfNecessary = true;
    private ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.CRC32;

    @Override
    public AbstractMetadataResolver createMetadataResolver() throws Exception {
        String bucketName = this.buildBucketName();
        ListObjectsV2Response result = this.s3Client.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).build());
        if (!result.hasContents()) {
            throw new SAMLException("No metadata bucket with valid contents can be found for " + bucketName);
        }
        List objects = result.contents();
        LOGGER.debug("Located {} S3 object(s) from bucket {}", (Object)objects.size(), (Object)bucketName);
        if (objects.isEmpty()) {
            throw new SAMLException("No metadata objects could be found in bucket " + bucketName);
        }
        String objectKey = this.entityId;
        LOGGER.debug("Fetching object {} from bucket {}", (Object)objectKey, (Object)bucketName);
        ResponseInputStream object = this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(objectKey).build());
        if (object != null) {
            return this.buildMetadataResolver((ResponseInputStream<GetObjectResponse>)object);
        }
        throw new SAMLException("Unable to locate metadata document for key " + objectKey);
    }

    protected AbstractMetadataResolver buildMetadataResolver(ResponseInputStream<GetObjectResponse> response) throws Exception {
        try (ByteArrayInputStream is = new ByteArrayInputStream(response.readAllBytes());){
            Document document = Configuration.getParserPool().parse((InputStream)is);
            Element root = document.getDocumentElement();
            DOMMetadataResolver dOMMetadataResolver = new DOMMetadataResolver(root);
            return dOMMetadataResolver;
        }
    }

    @Override
    public boolean storeMetadata(String metadata, boolean force) {
        if (CommonHelper.isBlank((String)metadata)) {
            this.logger.info("No metadata is provided");
            return false;
        }
        String metadataToUse = this.isSignMetadata() ? this.getMetadataSigner().sign(metadata) : metadata;
        CommonHelper.assertNotBlank((String)"metadata", (String)metadataToUse);
        EntityDescriptor entityDescriptor = Configuration.deserializeSamlObject(metadataToUse).map(EntityDescriptor.class::cast).orElseThrow();
        String metadataEntityId = entityDescriptor.getEntityID();
        if (!Objects.requireNonNull(metadataEntityId).equals(this.entityId)) {
            throw new SAMLException("Entity id from metadata " + metadataEntityId + " does not match supplied entity id " + this.entityId);
        }
        this.createMetadataBucketIfNecessary();
        return this.putMetadataInBucket(entityDescriptor, metadataToUse);
    }

    protected void createMetadataBucketIfNecessary() {
        String bucketNameToUse = this.buildBucketName();
        if (this.createBucketIfNecessary && this.s3Client.listBuckets((ListBucketsRequest)ListBucketsRequest.builder().build()).buckets().stream().noneMatch(b -> b.name().equalsIgnoreCase(bucketNameToUse))) {
            LOGGER.debug("Bucket {} does not exist. Creating...", (Object)bucketNameToUse);
            CreateBucketResponse bucket = this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketNameToUse).build());
            LOGGER.debug("Created bucket {} with name {}", (Object)bucket.location(), (Object)bucketNameToUse);
        }
    }

    protected boolean putMetadataInBucket(EntityDescriptor entityDescriptor, String metadataToUse) {
        PutObjectRequest request = this.buildPutRequest(entityDescriptor);
        LOGGER.debug("Saving metadata {} in bucket {}", (Object)metadataToUse, (Object)request.bucket());
        PutObjectResponse putResponse = this.s3Client.putObject(request, RequestBody.fromString((String)metadataToUse));
        return putResponse != null && putResponse.sdkHttpResponse().isSuccessful();
    }

    protected PutObjectRequest buildPutRequest(EntityDescriptor entityDescriptor) {
        Map<String, String> bucketMetadata = this.buildBucketMetadata(entityDescriptor);
        String bucketNameToUse = this.buildBucketName();
        PutObjectRequest.Builder builder = PutObjectRequest.builder().key(entityDescriptor.getEntityID()).bucket(bucketNameToUse).contentType(MediaType.XML_UTF_8.toString()).metadata(bucketMetadata).checksumAlgorithm(this.checksumAlgorithm);
        return this.customizePutRequest(builder, entityDescriptor);
    }

    protected PutObjectRequest customizePutRequest(PutObjectRequest.Builder builder, EntityDescriptor entityDescriptor) {
        return (PutObjectRequest)builder.build();
    }

    protected Map<String, String> buildBucketMetadata(EntityDescriptor entityDescriptor) {
        HashMap<String, String> bucketMetadata = new HashMap<String, String>();
        bucketMetadata.put("entityId", entityDescriptor.getEntityID());
        return bucketMetadata;
    }

    protected String buildBucketName() {
        return BUCKET_NAME_PREFIX;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2S3MetadataGenerator(S3Client s3Client, String entityId) {
        this.s3Client = s3Client;
        this.entityId = entityId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public S3Client getS3Client() {
        return this.s3Client;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCreateBucketIfNecessary() {
        return this.createBucketIfNecessary;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCreateBucketIfNecessary(boolean createBucketIfNecessary) {
        this.createBucketIfNecessary = createBucketIfNecessary;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }
}

