/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Collections;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.resource.SpringResourceHelper;
import org.pac4j.core.resource.SpringResourceLoader;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2IdentityProviderMetadataResolver
extends SpringResourceLoader<MetadataResolver>
implements SAML2MetadataResolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2IdentityProviderMetadataResolver.class);
    private Proxy proxy = Proxy.NO_PROXY;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private final SAML2Configuration configuration;

    public SAML2IdentityProviderMetadataResolver(SAML2Configuration configuration) {
        super(configuration.getIdentityProviderMetadataResource());
        if (configuration.getSslSocketFactory() != null) {
            this.setSslSocketFactory(configuration.getSslSocketFactory());
        }
        if (configuration.getHostnameVerifier() != null) {
            this.setHostnameVerifier(configuration.getHostnameVerifier());
        }
        this.configuration = configuration;
    }

    @Override
    public final MetadataResolver resolve() {
        return (MetadataResolver)this.load();
    }

    protected void internalLoad() {
        this.loaded = this.initializeMetadataResolver();
    }

    protected DOMMetadataResolver initializeMetadataResolver() {
        DOMMetadataResolver dOMMetadataResolver;
        block11: {
            InputStream in = SpringResourceHelper.getResourceInputStream((Resource)this.configuration.getIdentityProviderMetadataResource(), (Proxy)this.proxy, (SSLSocketFactory)this.sslSocketFactory, (HostnameVerifier)this.hostnameVerifier, (int)this.configuration.getIdentityProviderMetadataConnectTimeout(), (int)this.configuration.getIdentityProviderMetadataReadTimeout());
            try {
                Document parsedInput = Configuration.getParserPool().parse(in);
                Element metadataRoot = parsedInput.getDocumentElement();
                DOMMetadataResolver resolver = new DOMMetadataResolver(metadataRoot);
                resolver.setIndexes(Collections.singleton(new RoleMetadataIndex()));
                resolver.setParserPool(Configuration.getParserPool());
                resolver.setFailFastInitialization(true);
                resolver.setRequireValidMetadata(true);
                resolver.setId(resolver.getClass().getCanonicalName());
                resolver.initialize();
                dOMMetadataResolver = resolver;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new TechnicalException("Error loading idp metadata", (Throwable)e);
                }
                catch (ComponentInitializationException e) {
                    throw new TechnicalException("Error initializing idp metadata resolver", (Throwable)e);
                }
                catch (XMLParserException e) {
                    throw new TechnicalException("Error parsing idp metadata", (Throwable)e);
                }
                catch (IOException e) {
                    throw new TechnicalException("Error getting idp metadata resource", (Throwable)e);
                }
            }
            in.close();
        }
        return dOMMetadataResolver;
    }

    protected String determineIdentityProviderEntityId() {
        Iterator it;
        String idpEntityId = this.configuration.getIdentityProviderEntityId();
        if (idpEntityId == null && (it = ((IterableMetadataSource)this.loaded).iterator()).hasNext()) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)it.next();
            idpEntityId = entityDescriptor.getEntityID();
        }
        if (idpEntityId == null) {
            throw new SAMLException("No idp entityId found");
        }
        return idpEntityId;
    }

    @Override
    public String getEntityId() {
        XMLObject md = this.getEntityDescriptorElement();
        if (md instanceof EntitiesDescriptor) {
            return ((EntityDescriptor)((EntitiesDescriptor)md).getEntityDescriptors().get(0)).getEntityID();
        }
        if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SAMLException("No idp entityId found");
    }

    @Override
    public String getMetadata() {
        if (this.getEntityDescriptorElement() != null) {
            return Configuration.serializeSamlObject(this.getEntityDescriptorElement()).toString();
        }
        throw new TechnicalException("Metadata cannot be retrieved because entity descriptor is null");
    }

    @Override
    public final XMLObject getEntityDescriptorElement() {
        try {
            String idpEntityId = this.determineIdentityProviderEntityId();
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(idpEntityId)}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

