/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.redirect;

import java.util.Optional;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.api.SAML2ObjectBuilder;
import org.pac4j.saml.sso.impl.SAML2AuthnRequestBuilder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2RedirectionActionBuilder
implements RedirectionActionBuilder {
    private final SAML2Client client;
    protected SAML2ObjectBuilder<AuthnRequest> saml2ObjectBuilder;

    public SAML2RedirectionActionBuilder(SAML2Client client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
        this.saml2ObjectBuilder = new SAML2AuthnRequestBuilder();
    }

    public Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        SAML2MessageContext context = this.client.getContextProvider().buildContext(ctx, this.client);
        String relayState = this.client.getStateGenerator().generateValue(ctx);
        AuthnRequest authnRequest = this.saml2ObjectBuilder.build(context);
        this.client.getSSOMessageSender().sendMessage(context, authnRequest, relayState);
        Pac4jSAMLResponse adapter = context.getProfileRequestContextOutboundMessageTransportResponse();
        WebContext webContext = ctx.webContext();
        String bindingType = this.client.getConfiguration().getAuthnRequestBindingType();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equalsIgnoreCase(bindingType) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equalsIgnoreCase(bindingType)) {
            String content = adapter.getOutgoingContent();
            return Optional.of(HttpActionHelper.buildFormPostContentAction((WebContext)webContext, (String)content));
        }
        String location = adapter.getRedirectUrl();
        return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)location));
    }
}

