/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2LogoutRequestBuilder {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private String bindingType;
    private boolean useNameQualifier;
    private int issueInstantSkewSeconds = 0;

    public SAML2LogoutRequestBuilder(SAML2Configuration cfg) {
        this.bindingType = cfg.getSpLogoutRequestBindingType();
        this.useNameQualifier = cfg.isUseNameQualifier();
    }

    public LogoutRequest build(SAML2MessageContext context, SAML2Profile profile) {
        SingleLogoutService ssoService = context.getIDPSingleLogoutService(this.bindingType);
        return this.buildLogoutRequest(context, (Endpoint)ssoService, profile);
    }

    protected final LogoutRequest buildLogoutRequest(SAML2MessageContext context, Endpoint ssoService, SAML2Profile profile) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        LogoutRequest request = (LogoutRequest)builder.buildObject();
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(SAML2Utils.generateID());
        request.setIssuer(this.getIssuer(selfContext.getEntityId()));
        request.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.issueInstantSkewSeconds).toInstant());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setDestination(ssoService.getLocation());
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue(profile.getId());
        nameId.setFormat(profile.getSamlNameIdFormat());
        if (this.useNameQualifier) {
            nameId.setNameQualifier(profile.getSamlNameIdNameQualifier());
            nameId.setSPNameQualifier(profile.getSamlNameIdSpNameQualifier());
            nameId.setSPProvidedID(profile.getSamlNameIdSpProviderId());
        }
        request.setNameID(nameId);
        String sessIdx = profile.getSessionIndex();
        if (sessIdx != null) {
            SAMLObjectBuilder sessionIndexBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
            SessionIndex sessionIdx = (SessionIndex)sessionIndexBuilder.buildObject();
            sessionIdx.setValue(sessIdx);
            request.getSessionIndexes().add(sessionIdx);
        }
        return request;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

