/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SAML2Utils
implements HttpConstants {
    private static final Logger logger = LoggerFactory.getLogger(SAML2Utils.class);

    private SAML2Utils() {
    }

    public static String generateID() {
        return "_".concat(CommonHelper.randomString((int)39)).toLowerCase();
    }

    public static boolean urisEqualAfterPortNormalization(URI uri1, URI uri2) {
        if (uri1 == null && uri2 == null) {
            return true;
        }
        if (uri1 == null || uri2 == null) {
            return false;
        }
        try {
            URI normalizedUri1 = SAML2Utils.normalizePortNumbersInUri(uri1);
            URI normalizedUri2 = SAML2Utils.normalizePortNumbersInUri(uri2);
            boolean eq = normalizedUri1.equals(normalizedUri2);
            return eq;
        }
        catch (URISyntaxException use) {
            logger.error("Cannot compare 2 URIs.", (Throwable)use);
            return false;
        }
    }

    private static URI normalizePortNumbersInUri(URI uri) throws URISyntaxException {
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if ("http".equals(scheme) && port == 80) {
            port = -1;
        }
        if ("https".equals(scheme) && port == 443) {
            port = -1;
        }
        URI result = new URI(scheme, uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        return result;
    }
}

