/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import net.minidev.json.JSONObject;
import org.pac4j.core.profile.jwt.AbstractJwtProfile;
import org.pac4j.oidc.exceptions.OidcException;

public class OidcProfile
extends AbstractJwtProfile {
    private static final long serialVersionUID = -52855988661742374L;

    @JsonIgnore
    public String getFirstName() {
        return (String)this.getAttribute("given_name");
    }

    @JsonIgnore
    public String getMiddleName() {
        return (String)this.getAttribute("middle_name");
    }

    @JsonIgnore
    public String getDisplayName() {
        return (String)this.getAttribute("name");
    }

    @JsonIgnore
    public String getNickname() {
        return (String)this.getAttribute("nickname");
    }

    @JsonIgnore
    public String getUsername() {
        return (String)this.getAttribute("preferred_username");
    }

    @JsonIgnore
    public URI getPictureUrl() {
        return (URI)this.getAttribute("picture");
    }

    @JsonIgnore
    public URI getProfileUrl() {
        return (URI)this.getAttribute("profile");
    }

    @JsonIgnore
    public String getLocation() {
        return (String)this.getAttribute("zoneinfo");
    }

    @JsonIgnore
    public Boolean getEmailVerified() {
        return (Boolean)this.getAttribute("email_verified");
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)this.getAttribute("phone_number");
    }

    @JsonIgnore
    public Boolean getPhoneNumberVerified() {
        return (Boolean)this.getAttribute("phone_number_verified");
    }

    @JsonIgnore
    public Date getUpdatedAt() {
        return this.getAttributeAsDate("updated_at");
    }

    @JsonIgnore
    public Date getAuthTime() {
        return (Date)this.getAttribute("auth_time");
    }

    @JsonIgnore
    public String getNonce() {
        return (String)this.getAttribute("nonce");
    }

    @JsonIgnore
    public String getAcr() {
        return (String)this.getAttribute("acr");
    }

    @JsonIgnore
    public Object getAmr() {
        return this.getAttribute("amr");
    }

    @JsonIgnore
    public String getAzp() {
        return (String)this.getAttribute("azp");
    }

    public void setAccessToken(AccessToken accessToken) {
        if (accessToken != null) {
            String accessTokenBase64 = Base64.getEncoder().encodeToString(accessToken.toJSONString().getBytes(StandardCharsets.UTF_8));
            this.addAttribute("access_token", accessTokenBase64);
            if (accessToken.getLifetime() != 0L) {
                this.setExpiration(Date.from(Instant.now().plusSeconds(accessToken.getLifetime())));
            } else {
                Date exp = null;
                try {
                    JWTClaimsSet jwtClaimsSet = JWTParser.parse((String)accessToken.getValue()).getJWTClaimsSet();
                    if (jwtClaimsSet != null) {
                        exp = jwtClaimsSet.getExpirationTime();
                    }
                }
                catch (ParseException e) {
                    this.logger.trace(e.getMessage(), (Throwable)e);
                }
                this.setExpiration(exp);
            }
        }
    }

    @JsonIgnore
    public AccessToken getAccessToken() {
        try {
            Object accessTokenObject = this.getAttribute("access_token");
            if (accessTokenObject != null) {
                String accessTokenBase64 = accessTokenObject.toString();
                String base64Decoded = new String(Base64.getDecoder().decode(accessTokenBase64), StandardCharsets.UTF_8);
                JSONObject accessTokenJSON = new JSONObject((Map)new ObjectMapper().readValue(base64Decoded, Map.class));
                return AccessToken.parse((JSONObject)accessTokenJSON);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @JsonIgnore
    public String getIdTokenString() {
        return (String)this.getAttribute("id_token");
    }

    public void setIdTokenString(String idToken) {
        this.addAttribute("id_token", idToken);
    }

    @JsonIgnore
    public JWT getIdToken() {
        if (this.getIdTokenString() != null) {
            try {
                return JWTParser.parse((String)this.getIdTokenString());
            }
            catch (ParseException e) {
                throw new OidcException(e);
            }
        }
        return null;
    }

    @JsonIgnore
    public RefreshToken getRefreshToken() {
        try {
            Object refreshTokenObject = this.getAttribute("refresh_token");
            if (refreshTokenObject != null) {
                return new RefreshToken(refreshTokenObject.toString());
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        if (refreshToken != null) {
            this.addAttribute("refresh_token", refreshToken.getValue());
        }
    }

    public void removeLoginData() {
        this.removeAttribute("id_token");
        this.removeAttribute("access_token");
        this.removeAttribute("refresh_token");
    }

    @JsonIgnore
    public int getTokenExpirationAdvance() {
        Object tokenExpirationAdvance = this.getAttribute("token_expiration_advance");
        if (tokenExpirationAdvance != null) {
            if (tokenExpirationAdvance instanceof Long) {
                return ((Long)tokenExpirationAdvance).intValue();
            }
            if (tokenExpirationAdvance instanceof Integer) {
                return (Integer)tokenExpirationAdvance;
            }
        }
        return 0;
    }

    @JsonIgnore
    public void setTokenExpirationAdvance(int tokenExpirationAdvance) {
        this.addAttribute("token_expiration_advance", tokenExpirationAdvance);
    }

    @JsonIgnore
    public Date getExpiration() {
        return this.getAttributeAsDate("expiration");
    }

    public void setExpiration(Date expiration) {
        if (expiration != null) {
            this.addAttribute("expiration", expiration.getTime());
        } else {
            this.removeAttribute("expiration");
        }
    }

    @JsonIgnore
    public boolean isExpired() {
        int tokenExpirationAdvance = this.getTokenExpirationAdvance();
        if (tokenExpirationAdvance < 0) {
            return false;
        }
        Date expiration = this.getExpiration();
        return expiration != null && expiration.toInstant().isBefore(Instant.now().plusSeconds(tokenExpirationAdvance));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OidcProfile(super=" + super.toString() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcProfile() {
    }
}

