/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.logout.processor;

import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.logout.processor.LogoutProcessor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;

public class OidcLogoutProcessor
implements LogoutProcessor {
    protected OidcConfiguration configuration;

    public OidcLogoutProcessor(OidcConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public HttpAction processLogout(CallContext ctx, Credentials logoutCredentials) {
        CommonHelper.assertTrue((boolean)(logoutCredentials instanceof SessionKeyCredentials), (String)"credentials must be of type SessionKeyCredentials");
        SessionKeyCredentials credentials = (SessionKeyCredentials)logoutCredentials;
        String sessionKey = credentials.getSessionKey();
        SessionLogoutHandler sessionLogoutHandler = this.configuration.findSessionLogoutHandler();
        sessionLogoutHandler.destroySession(ctx, sessionKey);
        WebContext webContext = ctx.webContext();
        webContext.setResponseHeader("Cache-Control", "no-cache, no-store");
        webContext.setResponseHeader("Pragma", "no-cache");
        return new OkAction("");
    }
}

