/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.context.session;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.PrefixedSessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEESessionStore
extends PrefixedSessionStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JEESessionStore.class);
    protected HttpSession httpSession;

    public JEESessionStore() {
    }

    protected JEESessionStore(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    protected Optional<HttpSession> getNativeSession(WebContext context, boolean createSession) {
        if (this.httpSession != null) {
            LOGGER.debug("Provided session: {}", (Object)this.httpSession);
            return Optional.of(this.httpSession);
        }
        JEEContext jeeContext = (JEEContext)context;
        HttpSession session = jeeContext.getNativeRequest().getSession(createSession);
        LOGGER.debug("createSession: {}, retrieved session: {}", (Object)createSession, (Object)session);
        return Optional.ofNullable(session);
    }

    public Optional<String> getSessionId(WebContext context, boolean createSession) {
        Optional<HttpSession> httpSession = this.getNativeSession(context, createSession);
        if (httpSession.isPresent()) {
            String sessionId = httpSession.get().getId();
            LOGGER.debug("Get sessionId: {}", (Object)sessionId);
            return Optional.of(sessionId);
        }
        LOGGER.debug("No sessionId");
        return Optional.empty();
    }

    public Optional<Object> get(WebContext context, String key) {
        Optional<HttpSession> httpSession = this.getNativeSession(context, false);
        String prefixedKey = this.computePrefixedKey(key);
        if (httpSession.isPresent()) {
            Object value = httpSession.get().getAttribute(prefixedKey);
            LOGGER.debug("Get value: {} for key: {}", value, (Object)prefixedKey);
            return Optional.ofNullable(value);
        }
        LOGGER.debug("Can't get value for key: {}, no session available", (Object)prefixedKey);
        return Optional.empty();
    }

    public void set(WebContext context, String key, Object value) {
        String prefixedKey = this.computePrefixedKey(key);
        if (value == null) {
            Optional<HttpSession> httpSession = this.getNativeSession(context, false);
            if (httpSession.isPresent()) {
                LOGGER.debug("Remove value for key: {}", (Object)prefixedKey);
                httpSession.get().removeAttribute(prefixedKey);
            }
        } else {
            Optional<HttpSession> httpSession = this.getNativeSession(context, true);
            if (value instanceof Exception) {
                LOGGER.debug("Set key: {} for value: {}", (Object)prefixedKey, (Object)value.toString());
            } else {
                LOGGER.debug("Set key: {} for value: {}", (Object)prefixedKey, value);
            }
            httpSession.get().setAttribute(prefixedKey, value);
        }
    }

    public boolean destroySession(WebContext context) {
        Optional<HttpSession> httpSession = this.getNativeSession(context, false);
        if (httpSession.isPresent()) {
            HttpSession session = httpSession.get();
            LOGGER.debug("Invalidate session: {}", (Object)session);
            session.invalidate();
        }
        return true;
    }

    public Optional<Object> getTrackableSession(WebContext context) {
        Optional<HttpSession> httpSession = this.getNativeSession(context, false);
        if (httpSession.isPresent()) {
            HttpSession session = httpSession.get();
            LOGGER.debug("Return trackable session: {}", (Object)session);
            return Optional.of(session);
        }
        LOGGER.debug("No trackable session");
        return Optional.empty();
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        if (trackableSession != null) {
            LOGGER.debug("Rebuild session from trackable session: {}", trackableSession);
            JEESessionStore sessionStore = new JEESessionStore((HttpSession)trackableSession);
            sessionStore.setPrefix(this.getPrefix());
            return Optional.of(sessionStore);
        }
        LOGGER.debug("Unable to build session from trackable session");
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        Map<String, Object> attributes = new HashMap<String, Object>();
        HttpServletRequest request = ((JEEContext)context).getNativeRequest();
        HttpSession session = request.getSession(false);
        if (session != null) {
            LOGGER.debug("Discard old session: {}", (Object)session.getId());
            attributes = Collections.list(session.getAttributeNames()).stream().collect(Collectors.toMap(k -> k, arg_0 -> ((HttpSession)session).getAttribute(arg_0), (a, b) -> b));
            session.invalidate();
        }
        HttpSession newSession = request.getSession(true);
        LOGGER.debug("And copy all data to the new one: {}", (Object)newSession.getId());
        attributes.forEach((arg_0, arg_1) -> ((HttpSession)newSession).setAttribute(arg_0, arg_1));
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JEESessionStore(httpSession=" + this.httpSession + ")";
    }
}

