/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.credentials.extractor.CasCredentialsExtractor;
import org.pac4j.cas.logout.processor.CasLogoutProcessor;
import org.pac4j.cas.redirect.CasRedirectionActionBuilder;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.logout.CasLogoutActionBuilder;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.util.CommonHelper;

public class CasClient
extends IndirectClient {
    private CasConfiguration configuration = new CasConfiguration();

    public CasClient() {
    }

    public CasClient(CasConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setUrlResolver(this.getUrlResolver());
        this.setRedirectionActionBuilderIfUndefined(new CasRedirectionActionBuilder(this.configuration, this));
        this.setCredentialsExtractorIfUndefined(new CasCredentialsExtractor(this.configuration));
        this.setAuthenticatorIfUndefined(new CasAuthenticator(this.configuration, this.getName(), this.getUrlResolver(), this.getCallbackUrlResolver(), this.callbackUrl, this.findSessionLogoutHandler()));
        this.setLogoutProcessorIfUndefined(new CasLogoutProcessor(this.configuration, this.findSessionLogoutHandler()));
        this.setLogoutActionBuilderIfUndefined((LogoutActionBuilder)new CasLogoutActionBuilder(this.configuration.computeFinalPrefixUrl(null) + "logout", this.configuration.getPostLogoutUrlParameter()));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new QueryParameterCallbackUrlResolver(this.configuration.getCustomParams());
    }

    public void notifySessionRenewal(CallContext ctx, String oldSessionId) {
        SessionLogoutHandler sessionLogoutHandler = this.findSessionLogoutHandler();
        if (sessionLogoutHandler != null) {
            this.findSessionLogoutHandler().renewSession(ctx, oldSessionId);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CasClient(super=" + super.toString() + ", configuration=" + this.configuration + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }
}

