/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.mask;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import org.owasp.security.logging.SecurityMarkers;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class MaskingConverter
extends ReplacingCompositeConverter<ILoggingEvent> {
    public static final String MASKED_PASSWORD = "********";

    public String convert(ILoggingEvent event) {
        Marker eventMarker = event.getMarker();
        Object[] args = event.getArgumentArray();
        if (eventMarker != null && eventMarker.contains(SecurityMarkers.CONFIDENTIAL)) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = MASKED_PASSWORD;
            }
        }
        String maskedMessage = MessageFormatter.arrayFormat((String)event.getMessage(), (Object[])args).getMessage();
        return maskedMessage;
    }

    public void start() {
        this.started = true;
    }
}

