/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.util;

import org.owasp.security.logging.util.DefaultIntervalProperty;

public class ByteIntervalProperty
extends DefaultIntervalProperty {
    public ByteIntervalProperty(String name) {
        super(name);
    }

    @Override
    public String getValue() {
        String results = super.getValue();
        try {
            Long.parseLong(super.getValue());
            results = this.addUnits(super.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return results;
    }

    public String addUnits(String value) {
        StringBuffer buff = new StringBuffer(100);
        long bytes = Long.parseLong(value);
        if (bytes < 1000000L) {
            buff.append(value);
            buff.append("B");
        } else {
            int unit = 1000;
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = "kMGTPE".charAt(exp - 1) + "";
            String ov = String.format("%.1f%sB", (double)bytes / Math.pow(unit, exp), pre);
            buff.append(ov);
        }
        return buff.toString();
    }
}

