/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLSocketFactoryEx.class);
    private SSLContext sslCtxt;
    private String[] protocols;

    public SSLSocketFactoryEx() throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(null, null, null);
    }

    public SSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(km, tm, random);
    }

    public SSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(ctx);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslCtxt.getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslCtxt.getSocketFactory().getSupportedCipherSuites();
    }

    public String[] getDefaultProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    public String[] getSupportedProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        return ss;
    }

    private void initSSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = SSLContext.getInstance("TLS");
        this.sslCtxt.init(km, tm, random);
        this.protocols = this.getProtocolList();
    }

    private void initSSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = ctx;
        this.protocols = this.getProtocolList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getProtocolList() {
        String[] preferredProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
        Object[] availableProtocols = null;
        Socket socket = null;
        try {
            SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
            socket = (SSLSocket)factory.createSocket();
            availableProtocols = ((SSLSocket)socket).getSupportedProtocols();
            Arrays.sort(availableProtocols);
        }
        catch (Exception ex) {
            LOGGER.debug("Error getting protocol list, using TLSv1", (Throwable)ex);
            String[] stringArray = new String[]{"TLSv1"};
            return stringArray;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing socket", (Throwable)ex);
                }
            }
        }
        ArrayList<String> aa = new ArrayList<String>();
        for (String preferredProtocol : preferredProtocols) {
            int idx = Arrays.binarySearch(availableProtocols, preferredProtocol);
            if (idx < 0) continue;
            aa.add(preferredProtocol);
        }
        return aa.toArray(new String[0]);
    }
}

