/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.owasp.csrfguard.CsrfValidator;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.storage.LogicalSessionExtractor;
import org.owasp.csrfguard.token.transferobject.TokenTO;
import org.owasp.csrfguard.util.CsrfGuardUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = -1459584282530150483L;
    private static final String TOKEN_NAME_IDENTIFIER = "%TOKEN_NAME%";
    private static final String TOKEN_VALUE_IDENTIFIER = "%TOKEN_VALUE%";
    private static final String DOMAIN_ORIGIN_IDENTIFIER = "%DOMAIN_ORIGIN%";
    private static final String CONTEXT_PATH_IDENTIFIER = "%CONTEXT_PATH%";
    private static final String SERVLET_PATH_IDENTIFIER = "%SERVLET_PATH%";
    private static final String X_REQUESTED_WITH_IDENTIFIER = "%X_REQUESTED_WITH%";
    private static final String UNPROTECTED_EXTENSIONS_IDENTIFIER = "%UNPROTECTED_EXTENSIONS%";
    private static final String DYNAMIC_NODE_CREATION_EVENT_NAME_IDENTIFIER = "%DYNAMIC_NODE_CREATION_EVENT_NAME%";
    private static final String DOMAIN_STRICT_IDENTIFIER = "'%DOMAIN_STRICT%'";
    private static final String INJECT_INTO_XHR_IDENTIFIER = "'%INJECT_XHR%'";
    private static final String INJECT_INTO_FORMS_IDENTIFIER = "'%INJECT_FORMS%'";
    private static final String INJECT_GET_FORMS_IDENTIFIER = "'%INJECT_GET_FORMS%'";
    private static final String INJECT_FORM_ATTRIBUTES_IDENTIFIER = "'%INJECT_FORM_ATTRIBUTES%'";
    private static final String INJECT_INTO_ATTRIBUTES_IDENTIFIER = "'%INJECT_ATTRIBUTES%'";
    private static final String INJECT_INTO_DYNAMIC_NODES_IDENTIFIER = "'%INJECT_DYNAMIC_NODES%'";
    private static final String TOKENS_PER_PAGE_IDENTIFIER = "'%TOKENS_PER_PAGE%'";
    private static final String ASYNC_XHR = "'%ASYNC_XHR%'";
    private static final Map<String, BiFunction<CsrfGuard, HttpServletRequest, String>> JS_REPLACEMENT_MAP = new HashMap<String, BiFunction<CsrfGuard, HttpServletRequest, String>>();
    private static final String JSON_MIME_TYPE = "application/json";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript; charset=utf-8";
    private static final Set<String> javascriptUris;
    private static final Logger LOGGER;
    private static ServletConfig servletConfig;

    public static ServletConfig getStaticServletConfig() {
        return servletConfig;
    }

    public static Set<String> getJavascriptUris() {
        return javascriptUris;
    }

    public void init(ServletConfig theServletConfig) {
        servletConfig = theServletConfig;
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        csrfGuard.initializeJavaScriptConfiguration();
        CsrfGuardServletContextListener.printConfigIfConfigured(servletConfig.getServletContext(), "Printing properties after JavaScript servlet, note, the javascript properties have now been initialized: ");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isEnabled()) {
            if (CsrfGuardUtils.isPermittedUserAgent(request, response, csrfGuard)) {
                this.writeJavaScript(csrfGuard, request, response);
            }
        } else {
            response.setContentType(JAVASCRIPT_MIME_TYPE);
            String javaScriptCode = "console.log('CSRFGuard is disabled');";
            response.getWriter().write("console.log('CSRFGuard is disabled');");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (CsrfGuardUtils.isPermittedUserAgent(request, response, csrfGuard)) {
            if (new CsrfValidator().isValid(request, response)) {
                if (csrfGuard.isTokenPerPageEnabled()) {
                    LogicalSession logicalSession = csrfGuard.getLogicalSessionExtractor().extract(request);
                    if (Objects.isNull(logicalSession)) {
                        response.sendError(400, "Could not create a logical session from the current request.");
                    } else {
                        Map<String, String> pageTokens = csrfGuard.getTokenService().getPageTokens(logicalSession.getKey());
                        TokenTO tokenTO = new TokenTO(pageTokens);
                        JavaScriptServlet.writeTokens(response, tokenTO);
                    }
                } else {
                    response.sendError(400, "This endpoint should not be invoked if the Token-Per-Page functionality is disabled!");
                }
            } else {
                response.sendError(403, "Master token missing from the request.");
            }
        }
    }

    private static void writeTokens(HttpServletResponse response, TokenTO tokenTO) throws IOException {
        String jsonTokenTO = tokenTO.toString();
        response.setContentType(JSON_MIME_TYPE);
        response.setContentLength(jsonTokenTO.length());
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(jsonTokenTO);
    }

    private static void writeJavaScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isRotateEnabled() || csrfGuard.isTokenPerPageEnabled()) {
            response.setHeader("Cache-Control", "no-cache, no-store");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
        } else {
            response.setHeader("Cache-Control", csrfGuard.getJavascriptCacheControl());
        }
        response.setContentType(JAVASCRIPT_MIME_TYPE);
        String[] replacementList = (String[])JS_REPLACEMENT_MAP.values().stream().map(v -> (String)v.apply(csrfGuard, request)).toArray(String[]::new);
        String code = StringUtils.replaceEach((String)csrfGuard.getJavascriptTemplateCode(), (String[])JS_REPLACEMENT_MAP.keySet().toArray(new String[0]), (String[])replacementList);
        response.getWriter().write(code);
    }

    private static String getMasterToken(HttpServletRequest request, CsrfGuard csrfGuard) {
        LogicalSessionExtractor sessionKeyExtractor = csrfGuard.getLogicalSessionExtractor();
        LogicalSession logicalSession = sessionKeyExtractor.extractOrCreate(request);
        return csrfGuard.getTokenService().getMasterToken(logicalSession.getKey());
    }

    private static String parseDomain(StringBuffer url) {
        try {
            return new URL(url.toString()).getHost();
        }
        catch (MalformedURLException e) {
            return "INVALID_URL: " + url;
        }
    }

    private void writeJavaScript(CsrfGuard csrfGuard, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refererHeader = request.getHeader("referer");
        Pattern javascriptRefererPattern = csrfGuard.getJavascriptRefererPattern();
        String javaScriptReferer = javascriptRefererPattern.pattern();
        if (refererHeader != null) {
            if (!javascriptRefererPattern.matcher(refererHeader).matches()) {
                LOGGER.error("Referer domain '{}' does not match regex: '{}'", (Object)refererHeader, (Object)javaScriptReferer);
                response.sendError(403);
                return;
            }
            if (csrfGuard.isJavascriptRefererMatchDomain()) {
                boolean isJavascriptRefererMatchProtocol = csrfGuard.isJavascriptRefererMatchProtocol();
                String url = request.getRequestURL().toString();
                String requestProtocolAndDomain = CsrfGuardUtils.httpProtocolAndDomain(url, isJavascriptRefererMatchProtocol);
                String refererProtocolAndDomain = CsrfGuardUtils.httpProtocolAndDomain(refererHeader, isJavascriptRefererMatchProtocol);
                if (!refererProtocolAndDomain.equals(requestProtocolAndDomain)) {
                    LOGGER.error("Referer domain '{}' does not match request domain: '{}'", (Object)refererHeader, (Object)url);
                    response.sendError(403);
                    return;
                }
            }
        } else if (!javaScriptReferer.equals(".*")) {
            LOGGER.error("Missing referer headers are not accepted if a non-default referer pattern '{}' is configured!", (Object)javaScriptReferer);
            response.sendError(403);
            return;
        }
        String javascriptPath = request.getContextPath() + request.getServletPath();
        if (javascriptUris.size() < 100) {
            javascriptUris.add(javascriptPath);
        }
        JavaScriptServlet.writeJavaScript(request, response);
    }

    static {
        JS_REPLACEMENT_MAP.put(TOKEN_NAME_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)csrfGuard.getTokenName()));
        JS_REPLACEMENT_MAP.put(TOKEN_VALUE_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)JavaScriptServlet.getMasterToken(request, csrfGuard)));
        JS_REPLACEMENT_MAP.put(UNPROTECTED_EXTENSIONS_IDENTIFIER, (csrfGuard, request) -> String.valueOf(csrfGuard.getJavascriptUnprotectedExtensions()));
        JS_REPLACEMENT_MAP.put(CONTEXT_PATH_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)request.getContextPath()));
        JS_REPLACEMENT_MAP.put(SERVLET_PATH_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)(request.getContextPath() + request.getServletPath())));
        JS_REPLACEMENT_MAP.put(X_REQUESTED_WITH_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)csrfGuard.getJavascriptXrequestedWith()));
        JS_REPLACEMENT_MAP.put(DYNAMIC_NODE_CREATION_EVENT_NAME_IDENTIFIER, (csrfGuard, request) -> StringUtils.defaultString((String)csrfGuard.getJavascriptDynamicNodeCreationEventName()));
        JS_REPLACEMENT_MAP.put(DOMAIN_ORIGIN_IDENTIFIER, (csrfGuard, request) -> (String)ObjectUtils.defaultIfNull((Object)csrfGuard.getDomainOrigin(), (Object)StringUtils.defaultString((String)JavaScriptServlet.parseDomain(request.getRequestURL()))));
        JS_REPLACEMENT_MAP.put(INJECT_INTO_FORMS_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptInjectIntoForms()));
        JS_REPLACEMENT_MAP.put(INJECT_GET_FORMS_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptInjectGetForms()));
        JS_REPLACEMENT_MAP.put(INJECT_FORM_ATTRIBUTES_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptInjectFormAttributes()));
        JS_REPLACEMENT_MAP.put(INJECT_INTO_ATTRIBUTES_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptInjectIntoAttributes()));
        JS_REPLACEMENT_MAP.put(INJECT_INTO_DYNAMIC_NODES_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptInjectIntoDynamicallyCreatedNodes()));
        JS_REPLACEMENT_MAP.put(INJECT_INTO_XHR_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isAjaxEnabled()));
        JS_REPLACEMENT_MAP.put(TOKENS_PER_PAGE_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isTokenPerPageEnabled()));
        JS_REPLACEMENT_MAP.put(DOMAIN_STRICT_IDENTIFIER, (csrfGuard, request) -> Boolean.toString(csrfGuard.isJavascriptDomainStrict()));
        JS_REPLACEMENT_MAP.put(ASYNC_XHR, (csrfGuard, request) -> Boolean.toString(!csrfGuard.isForceSynchronousAjax()));
        javascriptUris = new HashSet<String>();
        LOGGER = LoggerFactory.getLogger(JavaScriptServlet.class);
        servletConfig = null;
    }
}

