/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.overlay;

import java.io.Serializable;
import org.owasp.csrfguard.config.overlay.ExpirableCache;

public class ExpirableValue<T>
implements Serializable {
    private long timePlacedInCache = System.currentTimeMillis();
    private long timeToLiveInCacheMillis = ExpirableCache.MAX_TIME_TO_LIVE_MILLIS;
    private T content = null;

    ExpirableValue(T theContent, long theTimeToLiveInCacheMillis) {
        if (theTimeToLiveInCacheMillis > 0L && theTimeToLiveInCacheMillis <= ExpirableCache.MAX_TIME_TO_LIVE_MILLIS) {
            this.timeToLiveInCacheMillis = theTimeToLiveInCacheMillis;
        }
        this.content = theContent;
    }

    T getContent() {
        if (this.expiredLongTime()) {
            throw new RuntimeException("This content is expired!");
        }
        return this.content;
    }

    boolean expired() {
        return System.currentTimeMillis() - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }

    boolean expiredLongTime() {
        return System.currentTimeMillis() - 3000L - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }
}

