/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.jar.DefaultMetaDataFactory;
import org.overlord.sramp.client.jar.DiscoveredArtifact;
import org.overlord.sramp.client.jar.JarToSrampArchive;
import org.overlord.sramp.client.jar.MetaDataFactory;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.wagon.models.MavenGavInfo;
import org.overlord.sramp.wagon.util.DevNullOutputStream;

@Component(role=Wagon.class, hint="sramp", instantiationStrategy="per-lookup")
public class SrampWagon
extends StreamWagon {
    @Requirement
    private Logger logger;
    private transient SrampArchive archive;
    private transient SrampAtomApiClient client;

    private String getSrampEndpoint() {
        String pomUrl = this.getRepository().getUrl();
        if (pomUrl.indexOf(63) > 0) {
            pomUrl = pomUrl.substring(0, pomUrl.indexOf(63));
        }
        String replace = pomUrl.replace("sramp:", "http:").replace("sramps:", "https:");
        return replace;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            this.archive = new SrampArchive();
            String endpoint = this.getSrampEndpoint();
            String username = "admin";
            String password = "overlord";
            AuthenticationInfo authInfo = this.getAuthenticationInfo();
            if (authInfo != null) {
                if (authInfo.getUserName() != null) {
                    username = authInfo.getUserName();
                }
                if (authInfo.getPassword() != null) {
                    password = authInfo.getPassword();
                }
            }
            this.client = new SrampAtomApiClient(endpoint, username, password, true);
        }
        catch (SrampArchiveException e) {
            throw new ConnectionException("Failed to create the s-ramp archive (temporary storage).", (Throwable)e);
        }
        catch (SrampClientException e) {
            throw new ConnectionException("Failed to connect to the S-RAMP repository.", (Throwable)e);
        }
        catch (SrampAtomException e) {
            throw new ConnectionException("Failed to connect to the S-RAMP repository.", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    public void closeConnection() throws ConnectionException {
        SrampArchive.closeQuietly((SrampArchive)this.archive);
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        if (resource.getName().contains("maven-metadata.xml")) {
            throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
        }
        this.logger.debug("Looking up resource from s-ramp repository: " + resource);
        MavenGavInfo gavInfo = MavenGavInfo.fromResource(resource);
        if (gavInfo.isHash()) {
            this.doGetHash(gavInfo, inputData);
        } else {
            this.doGetArtifact(gavInfo, inputData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetHash(MavenGavInfo gavInfo, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String hashPropName;
        String artyPath = gavInfo.getFullName();
        if (gavInfo.getType().endsWith(".md5")) {
            hashPropName = "maven.hash.md5";
            artyPath = artyPath.substring(0, artyPath.length() - 4);
        } else {
            hashPropName = "maven.hash.sha1";
            artyPath = artyPath.substring(0, artyPath.length() - 5);
        }
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            SrampArchiveEntry entry = this.archive.getEntry(artyPath);
            if (entry == null) {
                throw new ResourceDoesNotExistException("Failed to find resource hash: " + gavInfo.getName());
            }
            BaseArtifactType metaData = entry.getMetaData();
            String hashValue = SrampModelUtils.getCustomProperty((BaseArtifactType)metaData, (String)hashPropName);
            if (hashValue == null) {
                throw new ResourceDoesNotExistException("Failed to find resource hash: " + gavInfo.getName());
            }
            inputData.setInputStream(IOUtils.toInputStream((String)hashValue));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetArtifact(MavenGavInfo gavInfo, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            BaseArtifactType artifact = this.findExistingArtifact(this.client, gavInfo);
            if (artifact == null) {
                throw new ResourceDoesNotExistException("Artifact not found in s-ramp repository: '" + gavInfo.getName() + "'");
            }
            this.archive.addEntry(gavInfo.getFullName(), artifact, null);
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            InputStream artifactContent = this.client.getArtifactContent(type, artifact.getUuid());
            inputData.setInputStream(artifactContent);
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (SrampClientException e) {
            if (e.getCause() instanceof HttpHostConnectException) {
                this.logger.debug("Could not connect to s-ramp repository: " + e.getMessage());
            } else {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            throw new ResourceDoesNotExistException("Failed to get resource from s-ramp: " + gavInfo.getName());
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.putCommon(resource, null, stream);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.putCommon(resource, null, stream);
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        FileInputStream resourceInputStream = null;
        try {
            resourceInputStream = new FileInputStream(source);
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException(e.getMessage());
        }
        Resource resource = new Resource(resourceName);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.putCommon(resource, source, resourceInputStream);
    }

    private void putCommon(Resource resource, File source, InputStream content) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.logger.info("Uploading s-ramp artifact: " + resource.getName());
        this.firePutInitiated(resource, source);
        this.firePutStarted(resource, source);
        if (resource.getName().contains("maven-metadata.xml")) {
            this.logger.info("Skipping unsupported artifact: " + resource.getName());
            try {
                this.transfer(resource, content, new DevNullOutputStream(), 6);
            }
            catch (IOException e) {
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.doPut(resource, content);
        }
        this.firePutCompleted(resource, source);
    }

    private ArtifactType getArtifactType(MavenGavInfo gavInfo) {
        String customAT = this.getParamFromRepositoryUrl("artifactType");
        if (gavInfo.getType().equals("pom")) {
            return ArtifactType.valueOf((String)"MavenPom");
        }
        if (this.isPrimaryArtifact(gavInfo) && customAT != null) {
            return ArtifactType.valueOf((String)customAT);
        }
        String fileName = gavInfo.getName();
        int extensionIdx = fileName.lastIndexOf(46);
        String extension = gavInfo.getName().substring(extensionIdx + 1);
        return ArtifactType.fromFileExtension((String)extension);
    }

    private void doPut(Resource resource, InputStream resourceInputStream) throws TransferFailedException {
        MavenGavInfo gavInfo = MavenGavInfo.fromResource(resource);
        if (gavInfo.isHash()) {
            this.doPutHash(gavInfo, resourceInputStream);
        } else {
            this.doPutArtifact(gavInfo, resourceInputStream);
        }
    }

    private void doPutHash(MavenGavInfo gavInfo, InputStream resourceInputStream) throws TransferFailedException {
        this.logger.info("Storing hash value as s-ramp property: " + gavInfo.getName());
        try {
            String hashPropName;
            String artyPath = gavInfo.getFullName();
            if (gavInfo.getType().endsWith(".md5")) {
                hashPropName = "maven.hash.md5";
                artyPath = artyPath.substring(0, artyPath.length() - 4);
            } else {
                hashPropName = "maven.hash.sha1";
                artyPath = artyPath.substring(0, artyPath.length() - 5);
            }
            String hashValue = IOUtils.toString((InputStream)resourceInputStream);
            ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
            try {
                SrampArchiveEntry entry = this.archive.getEntry(artyPath);
                BaseArtifactType metaData = entry.getMetaData();
                SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)hashPropName, (String)hashValue);
                this.archive.updateEntry(entry, null);
                this.client.updateArtifactMetaData(metaData);
            }
            catch (Throwable t) {
                throw new TransferFailedException(t.getMessage(), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
            }
        }
        catch (Exception e) {
            throw new TransferFailedException("Failed to store a hash: " + gavInfo.getName(), (Throwable)e);
        }
    }

    private void doPutArtifact(final MavenGavInfo gavInfo, InputStream resourceInputStream) throws TransferFailedException {
        ArtifactType artifactType = this.getArtifactType(gavInfo);
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        File tempResourceFile = null;
        SrampArchive archive = null;
        JarToSrampArchive j2sramp = null;
        BaseArtifactType artifactGrouping = null;
        try {
            String parentUUID;
            BaseArtifactType artifact;
            tempResourceFile = this.stashResourceContent(resourceInputStream);
            resourceInputStream = FileUtils.openInputStream((File)tempResourceFile);
            if (this.isPrimaryArtifact(gavInfo) && this.getParamFromRepositoryUrl("artifactGrouping") != null) {
                artifactGrouping = this.ensureArtifactGrouping();
            }
            if ((artifact = this.findExistingArtifactByGAV(this.client, gavInfo)) != null) {
                this.archive.addEntry(gavInfo.getFullName(), artifact, null);
                this.client.updateArtifactContent(artifact, resourceInputStream);
                if (this.shouldExpand(gavInfo)) {
                    parentUUID = artifact.getUuid();
                    this.cleanExpandedArtifacts(this.client, parentUUID);
                }
            } else {
                artifact = this.client.uploadArtifact(artifactType, resourceInputStream, gavInfo.getName());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)gavInfo.getGroupId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)gavInfo.getArtifactId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)gavInfo.getVersion());
                if (gavInfo.getClassifier() != null) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier", (String)gavInfo.getClassifier());
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.type", (String)gavInfo.getType());
                if (artifactGrouping != null) {
                    SrampModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"groupedBy", (String)artifactGrouping.getUuid());
                    SrampModelUtils.addGenericRelationship((BaseArtifactType)artifactGrouping, (String)"groups", (String)artifact.getUuid());
                    this.client.updateArtifactMetaData(artifactGrouping);
                }
                this.client.updateArtifactMetaData(artifact);
                this.archive.addEntry(gavInfo.getFullName(), artifact, null);
            }
            if (this.shouldExpand(gavInfo)) {
                parentUUID = artifact.getUuid();
                j2sramp = new JarToSrampArchive(tempResourceFile);
                j2sramp.setMetaDataFactory((MetaDataFactory)new DefaultMetaDataFactory(){

                    public BaseArtifactType createMetaData(DiscoveredArtifact artifact) {
                        BaseArtifactType metaData = super.createMetaData(artifact);
                        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"maven.parent-groupId", (String)gavInfo.getGroupId());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"maven.parent-artifactId", (String)gavInfo.getArtifactId());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"maven.parent-version", (String)gavInfo.getVersion());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"maven.parent-type", (String)gavInfo.getType());
                        SrampModelUtils.addGenericRelationship((BaseArtifactType)metaData, (String)"expandedFromDocument", (String)parentUUID);
                        return metaData;
                    }
                });
                archive = j2sramp.createSrampArchive();
                this.client.uploadBatch(archive);
            }
        }
        catch (Throwable t) {
            throw new TransferFailedException(t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
            SrampArchive.closeQuietly(archive);
            JarToSrampArchive.closeQuietly(j2sramp);
            FileUtils.deleteQuietly((File)tempResourceFile);
        }
    }

    private BaseArtifactType ensureArtifactGrouping() throws SrampClientException, SrampAtomException {
        String groupingName = this.getParamFromRepositoryUrl("artifactGrouping");
        if (groupingName == null || groupingName.trim().length() == 0) {
            this.logger.warn("No Artifact Grouping name configured.");
            return null;
        }
        QueryResultSet query = this.client.buildQuery("/s-ramp/ext/ArtifactGrouping[@name = ?]").parameter(groupingName).count(2).query();
        if (query.size() > 1L) {
            this.logger.warn("Multiple Artifact Groupings found with the same name: " + groupingName);
            return null;
        }
        if (query.size() == 1L) {
            ArtifactSummary summary = query.get(0);
            return this.client.getArtifactMetaData(summary.getType(), summary.getUuid());
        }
        ExtendedArtifactType groupingArtifact = new ExtendedArtifactType();
        groupingArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        groupingArtifact.setExtendedType("ArtifactGrouping");
        groupingArtifact.setName(groupingName);
        groupingArtifact.setDescription("An Artifact Grouping automatically created by the S-RAMP Maven Wagon (integration between S-RAMP and Maven).");
        return this.client.createArtifact((BaseArtifactType)groupingArtifact);
    }

    private void cleanExpandedArtifacts(SrampAtomApiClient client, String parentUUID) throws SrampAtomException, SrampClientException {
        String query = String.format("/s-ramp[mavenParent[@uuid = '%1$s']]", parentUUID);
        boolean done = false;
        while (!done) {
            QueryResultSet rset = client.query(query, 0, 20, "name", true);
            if (rset.size() == 0L) {
                done = true;
                continue;
            }
            for (ArtifactSummary entry : rset) {
                ArtifactType artifactType = entry.getType();
                String uuid = entry.getUuid();
                client.deleteArtifact(uuid, artifactType);
            }
        }
    }

    private boolean shouldExpand(MavenGavInfo gavInfo) {
        HashSet<String> expandedTypes = new HashSet<String>();
        expandedTypes.add("jar");
        expandedTypes.add("war");
        expandedTypes.add("ear");
        return expandedTypes.contains(gavInfo.getType()) && gavInfo.getClassifier() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File stashResourceContent(InputStream resourceInputStream) throws IOException {
        File resourceTempFile = null;
        FileOutputStream oStream = null;
        try {
            resourceTempFile = File.createTempFile("s-ramp-wagon-resource", ".tmp");
            oStream = FileUtils.openOutputStream((File)resourceTempFile);
        }
        catch (Throwable throwable) {
            IOUtils.copy((InputStream)resourceInputStream, oStream);
            IOUtils.closeQuietly((InputStream)resourceInputStream);
            IOUtils.closeQuietly((OutputStream)oStream);
            throw throwable;
        }
        IOUtils.copy((InputStream)resourceInputStream, (OutputStream)oStream);
        IOUtils.closeQuietly((InputStream)resourceInputStream);
        IOUtils.closeQuietly((OutputStream)oStream);
        return resourceTempFile;
    }

    private BaseArtifactType findExistingArtifact(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        BaseArtifactType artifact = this.findExistingArtifactByGAV(client, gavInfo);
        if (artifact == null) {
            artifact = this.findExistingArtifactByUniversal(client, gavInfo);
        }
        return artifact;
    }

    private BaseArtifactType findExistingArtifactByGAV(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        String query = null;
        query = gavInfo.getClassifier() == null ? String.format("/s-ramp[@maven.groupId = '%1$s' and @maven.artifactId = '%2$s' and @maven.version = '%3$s' and @maven.type = '%4$s']", gavInfo.getGroupId(), gavInfo.getArtifactId(), gavInfo.getVersion(), gavInfo.getType()) : String.format("/s-ramp[@maven.groupId = '%1$s' and @maven.artifactId = '%2$s' and @maven.version = '%3$s' and @maven.classifier = '%4$s' and @maven.type = '%5$s']", gavInfo.getGroupId(), gavInfo.getArtifactId(), gavInfo.getVersion(), gavInfo.getClassifier(), gavInfo.getType());
        QueryResultSet rset = client.query(query);
        if (rset.size() > 0L) {
            for (ArtifactSummary summary : rset) {
                String uuid = summary.getUuid();
                ArtifactType artifactType = summary.getType();
                BaseArtifactType arty = client.getArtifactMetaData(artifactType, uuid);
                if (gavInfo.getClassifier() == null) {
                    String artyClassifier = SrampModelUtils.getCustomProperty((BaseArtifactType)arty, (String)"maven.classifier");
                    if (artyClassifier != null) continue;
                    return arty;
                }
                return arty;
            }
        }
        return null;
    }

    private BaseArtifactType findExistingArtifactByUniversal(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        String artifactType = gavInfo.getGroupId().substring(gavInfo.getGroupId().indexOf(46) + 1);
        String uuid = gavInfo.getArtifactId();
        try {
            return client.getArtifactMetaData(ArtifactType.valueOf((String)artifactType), uuid);
        }
        catch (Throwable t) {
            this.logger.debug(t.getMessage());
            return null;
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new RuntimeException("Should never get here!");
    }

    protected String getParamFromRepositoryUrl(String paramName) {
        String[] params;
        String url = this.getRepository().getUrl();
        int idx = url.indexOf(63);
        if (idx == -1) {
            return null;
        }
        String query = url.substring(idx + 1);
        for (String paramPair : params = query.split("&")) {
            String[] pp = paramPair.split("=");
            if (pp.length == 2) {
                String key = pp[0];
                String val = pp[1];
                if (!key.equals(paramName)) continue;
                return val;
            }
            throw new RuntimeException("Invalid query parameter in repository URL (param name without value).");
        }
        return null;
    }

    protected boolean isPrimaryArtifact(MavenGavInfo gavInfo) {
        return gavInfo.getClassifier() == null && !gavInfo.getType().equals("pom");
    }
}

