/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.models;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.wagon.resource.Resource;

public class MavenGavInfo {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;

    public static MavenGavInfo fromResource(Resource resource) {
        String resourceName = resource.getName();
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(resourceName.split("/")));
        String filename = (String)segments.remove(segments.size() - 1);
        String type = filename.substring(filename.lastIndexOf(46) + 1);
        if (filename.endsWith(".sha1")) {
            type = filename.substring(0, filename.length() - 5);
            type = type.substring(type.lastIndexOf(46) + 1) + ".sha1";
        }
        String version = (String)segments.remove(segments.size() - 1);
        String artifactId = (String)segments.remove(segments.size() - 1);
        String groupId = StringUtils.join(segments, (String)".");
        MavenGavInfo gav = new MavenGavInfo();
        gav.setGroupId(groupId);
        gav.setArtifactId(artifactId);
        gav.setVersion(version);
        gav.setType(type);
        return gav;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("groupId: ");
        builder.append(this.getGroupId());
        builder.append("  artifactId: ");
        builder.append(this.getArtifactId());
        builder.append("  version: ");
        builder.append(this.getVersion());
        builder.append("  type: ");
        builder.append(this.getType());
        return builder.toString();
    }
}

