/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.i18n.Messages;

public class PropertyCommand
extends BuiltInShellCommand {
    private static final Set<String> CORE_PROPERTIES = new HashSet<String>();

    public PropertyCommand() {
        CORE_PROPERTIES.add("name");
        CORE_PROPERTIES.add("description");
        CORE_PROPERTIES.add("version");
    }

    public boolean execute() throws Exception {
        block7: {
            String subcmdArg = this.requiredArgument(0, Messages.i18n.format("Property.InvalidArgMsg.SubCommand", new Object[0]));
            String propNameArg = this.requiredArgument(1, Messages.i18n.format("Property.InvalidArgMsg.PropertyName", new Object[0]));
            String propValueArg = null;
            if ("set".equals(subcmdArg)) {
                propValueArg = this.optionalArgument(2);
            }
            QName artifactVarName = new QName("s-ramp", "artifact");
            BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print(Messages.i18n.format("NoActiveArtifact", new Object[0]), new Object[0]);
                return false;
            }
            try {
                if ("set".equals(subcmdArg)) {
                    this.setProperty(artifact, propNameArg, propValueArg);
                    this.print(Messages.i18n.format("Property.PropertySet", new Object[]{propNameArg}), new Object[0]);
                    break block7;
                }
                if ("unset".equals(subcmdArg)) {
                    this.unsetProperty(artifact, propNameArg);
                    this.print(Messages.i18n.format("Property.PropertyUnset", new Object[]{propNameArg}), new Object[0]);
                    break block7;
                }
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("Property.InvalidSubCommand", new Object[0]));
            }
            catch (InvalidCommandArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.print(Messages.i18n.format("Property.Failure", new Object[0]), new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private void setProperty(BaseArtifactType artifact, String propName, String propValue) {
        String propNameLC = propName.toLowerCase();
        if (CORE_PROPERTIES.contains(propNameLC)) {
            if (propNameLC.equals("name")) {
                artifact.setName(propValue);
            } else if (propNameLC.equals("description")) {
                artifact.setDescription(propValue);
            } else if (propNameLC.equals("version")) {
                artifact.setVersion(propValue);
            }
        } else {
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propName, (String)propValue);
        }
    }

    private void unsetProperty(BaseArtifactType artifact, String propName) {
        String propNameLC = propName.toLowerCase();
        if (CORE_PROPERTIES.contains(propNameLC)) {
            this.setProperty(artifact, propName, null);
        } else {
            SrampModelUtils.unsetCustomProperty((BaseArtifactType)artifact, (String)propName);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        BaseArtifactType artifact;
        QName artifactVarName = new QName("s-ramp", "artifact");
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                candidates.add("set ");
                candidates.add("unset ");
                return 0;
            }
            if ("set".startsWith(lastArgument)) {
                candidates.add("set ");
                return 0;
            }
            if ("unset".startsWith(lastArgument)) {
                candidates.add("unset ");
                return 0;
            }
        } else if (this.getArguments().size() == 1 && (this.getArguments().contains((Object)"set") || this.getArguments().contains((Object)"unset")) && (artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName)) != null) {
            TreeSet<String> props = new TreeSet<String>();
            props.addAll(CORE_PROPERTIES);
            props.addAll(this.getCustomPropertyNames(artifact));
            String candidatePostfix = " ";
            if (this.getArguments().contains((Object)"unset")) {
                candidatePostfix = "";
            }
            for (String prop : props) {
                if (lastArgument != null && !prop.startsWith(lastArgument)) continue;
                candidates.add(prop + candidatePostfix);
            }
            return 0;
        }
        return -1;
    }

    private Collection<String> getCustomPropertyNames(BaseArtifactType artifact) {
        HashSet<String> props = new HashSet<String>();
        for (Property prop : artifact.getProperty()) {
            props.add(prop.getPropertyName());
        }
        return props;
    }
}

