/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.util.Locale;
import org.overlord.sramp.shell.ShellArguments;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.ShellCommandReaderFactory;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public abstract class AbstractSrampShell {
    protected static final String LOCALE_PROPERTY = "s-ramp.shell.locale";
    private final ShellCommandFactory factory = new ShellCommandFactory();
    private final ShellContextImpl context = new ShellContextImpl();
    private ShellCommandReader reader;

    public void run(String[] args) throws Exception {
        ShellArguments shellArgs = new ShellArguments(args);
        this.reader = ShellCommandReaderFactory.createCommandReader(shellArgs, this.factory, this.context);
        this.context.setReader(this.reader);
        this.reader.open();
        this.displayWelcomeMessage();
        boolean done = false;
        while (!done) {
            ShellCommand command = null;
            try {
                command = this.reader.read();
                if (command == null) {
                    done = true;
                    continue;
                }
                boolean success = command.execute();
                if (success || !this.reader.isBatch()) continue;
                this.exit();
            }
            catch (InvalidCommandArgumentException e) {
                System.out.println(Messages.i18n.format("Shell.INVALID_ARG", new Object[]{e.getMessage()}));
                if (command != null) {
                    System.out.println(Messages.i18n.format("Shell.USAGE", new Object[0]));
                    command.printUsage();
                }
                if (!this.reader.isBatch()) continue;
                this.exit();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (!this.reader.isBatch()) continue;
                this.exit();
            }
        }
    }

    public void shutdown() {
        System.out.print(Messages.i18n.format("Shell.SHUTTING_DOWN", new Object[0]));
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.context.destroy();
        System.out.println(Messages.i18n.format("Shell.DONE", new Object[0]));
    }

    private void displayWelcomeMessage() {
        System.out.println("**********************************************************************\n           _____       ______  ___ ___  ________  \n          /  ___|      | ___ \\/ _ \\|  \\/  | ___ \\ \n          \\ `--. ______| |_/ / /_\\ \\ .  . | |_/ / \n           `--. \\______|    /|  _  | |\\/| |  __/  \n          /\\__/ /      | |\\ \\| | | | |  | | |     \n          \\____/       \\_| \\_\\_| |_|_|  |_|_|     \n                                                  \n  Overlord S-RAMP, Licensed under Apache License V2.0, Copyright 2014\n  Locale: " + Locale.getDefault().toString().trim() + "\n" + "**********************************************************************");
    }

    protected abstract void exit() throws Exception;
}

