/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.storedquery;

import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.commands.storedquery.StoredQueryCommandUtil;
import org.overlord.sramp.shell.i18n.Messages;

public class GetStoredQueryCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String name = this.requiredArgument(0, Messages.i18n.format("StoredQuery.Name.Mandatory", new Object[0]));
        SrampAtomApiClient client = StoredQueryCommandUtil.client(this, this.getContext());
        if (client == null) {
            return false;
        }
        try {
            StoredQuery storedQuery = client.getStoredQuery(name);
            this.print(storedQuery);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("GetStoredQueryCommand.Fail", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    private void print(StoredQuery storedQuery) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{StoredQuery.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)storedQuery, (OutputStream)System.out);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return StoredQueryCommandUtil.tabCompletion(this, this.getArguments(), this.getContext(), candidates);
    }
}

