/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class UpdateMetaDataCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print(Messages.i18n.format("NoActiveArtifact", new Object[0]), new Object[0]);
            return false;
        }
        try {
            client.updateArtifactMetaData(artifact);
            this.print(Messages.i18n.format("UpdateMetaData.Success", new Object[]{artifact.getName()}), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("UpdateMetaData.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
        return true;
    }
}

