/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class UpdateContentCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String contentFilePathArg = this.requiredArgument(0, Messages.i18n.format("UpdateContent.InvalidArgMsg.PathToContent", new Object[0]));
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print(Messages.i18n.format("NoActiveArtifact", new Object[0]), new Object[0]);
            return false;
        }
        File file = new File(contentFilePathArg);
        if (!file.isFile()) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("UpdateContent.InvalidArgMsg.PathToFile", new Object[0]));
        }
        FileInputStream content = null;
        try {
            content = FileUtils.openInputStream((File)file);
            client.updateArtifactContent(artifact, (InputStream)content);
            this.print(Messages.i18n.format("UpdateContent.Success", new Object[]{artifact.getName()}), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("UpdateContent.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
            return false;
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

