/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class ConnectCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        boolean validating;
        String endpointUrlArg = this.requiredArgument(0, Messages.i18n.format("Connect.InvalidArgMsg.NoUrl", new Object[0]));
        String opt1 = this.optionalArgument(1);
        String opt2 = this.optionalArgument(2);
        String opt3 = this.optionalArgument(3);
        String username = null;
        String password = null;
        String disableValidationOptionArg = null;
        if (opt3 != null) {
            username = opt1;
            password = opt2;
            disableValidationOptionArg = opt3;
        } else if (opt2 != null) {
            username = opt1;
            password = opt2;
        } else {
            disableValidationOptionArg = opt1;
        }
        if (username == null) {
            username = this.promptForUsername();
        }
        if (password == null) {
            password = this.promptForPassword();
        }
        boolean bl = validating = !"--disableValidation".equals(disableValidationOptionArg);
        if (!endpointUrlArg.startsWith("http")) {
            endpointUrlArg = "http://" + endpointUrlArg;
        }
        QName varName = new QName("s-ramp", "client");
        try {
            SrampAtomApiClient client = null;
            client = new SrampAtomApiClient(endpointUrlArg, username, password, validating);
            this.getContext().setVariable(varName, (Object)client);
            this.print(Messages.i18n.format("Connect.Success", new Object[]{endpointUrlArg}), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("Connect.Failure", new Object[]{endpointUrlArg}), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    private String promptForUsername() {
        String username = System.getProperty("s-ramp.shell.username");
        if (username != null) {
            return username;
        }
        return this.getContext().promptForInput(Messages.i18n.format("Connect.UserPrompt", new Object[0]));
    }

    private String promptForPassword() {
        String password = System.getProperty("s-ramp.shell.password");
        if (password != null) {
            return password;
        }
        return this.getContext().promptForPassword(Messages.i18n.format("Connect.PasswordPrompt", new Object[0]));
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            candidates.add("http://localhost:8080/s-ramp-server");
            return 0;
        }
        return -1;
    }
}

