/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.i18n.Messages;

public class ClassificationCommand
extends BuiltInShellCommand {
    private static final Set<String> subcommands = new HashSet<String>();

    public ClassificationCommand() {
        subcommands.add("add");
        subcommands.add("remove");
        subcommands.add("clear");
    }

    public boolean execute() throws Exception {
        block10: {
            String subcmdArg = this.requiredArgument(0, Messages.i18n.format("Classification.InvalidArgMsg", new Object[0]));
            String classificationArg = null;
            if ("add".equals(subcmdArg) || "remove".equals(subcmdArg)) {
                classificationArg = this.requiredArgument(1, Messages.i18n.format("Classification.InvalidArgMsg.ClassificationUri", new Object[0]));
            }
            QName artifactVarName = new QName("s-ramp", "artifact");
            BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print(Messages.i18n.format("NoActiveArtifact", new Object[0]), new Object[0]);
                return false;
            }
            try {
                if ("add".equals(subcmdArg)) {
                    artifact.getClassifiedBy().add(classificationArg);
                    this.print(Messages.i18n.format("Classification.ClassificationAdded", new Object[]{classificationArg}), new Object[0]);
                    break block10;
                }
                if ("remove".equals(subcmdArg)) {
                    if (artifact.getClassifiedBy().remove(classificationArg)) {
                        this.print(Messages.i18n.format("Classification.ClassificationRemoved", new Object[0]), new Object[]{classificationArg});
                        break block10;
                    }
                    this.print(Messages.i18n.format("Classification.ClassificationDoesNotExist", new Object[0]), new Object[]{classificationArg});
                    return false;
                }
                if ("clear".equals(subcmdArg)) {
                    if (!artifact.getClassifiedBy().isEmpty()) {
                        artifact.getClassifiedBy().clear();
                        this.print(Messages.i18n.format("Classification.AllRemoved", new Object[0]), new Object[0]);
                        break block10;
                    }
                    this.print(Messages.i18n.format("Classification.NoneExist", new Object[0]), new Object[0]);
                    return false;
                }
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("Classification.InvalidSubCommand", new Object[0]));
            }
            catch (InvalidCommandArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.print(Messages.i18n.format("Classification.ModificationFailed", new Object[0]), new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                return false;
            }
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        BaseArtifactType artifact;
        QName artifactVarName = new QName("s-ramp", "artifact");
        if (this.getArguments().isEmpty()) {
            for (String subcmd : subcommands) {
                if (lastArgument != null && !subcmd.startsWith(lastArgument)) continue;
                candidates.add(subcmd + " ");
            }
            return 0;
        }
        if (this.getArguments().size() == 1 && this.getArguments().contains((Object)"remove") && (artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName)) != null) {
            TreeSet classifications = new TreeSet();
            classifications.addAll(artifact.getClassifiedBy());
            for (String classification : classifications) {
                if (lastArgument != null && !classification.startsWith(lastArgument)) continue;
                candidates.add(classification);
            }
            return 0;
        }
        return -1;
    }
}

