/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.util.List;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.AbstractShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.api.ShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class OpenArchiveCommand
extends AbstractArchiveCommand {
    public boolean execute() throws Exception {
        super.initialize();
        String pathToArchive = this.requiredArgument(0, Messages.i18n.format("OpenArchive.InvalidArgMsg.PathToArchive", new Object[0]));
        if (!this.validate(new String[0])) {
            return false;
        }
        File archiveFile = new File(pathToArchive);
        this.archive = new SrampArchive(archiveFile);
        this.getContext().setVariable(this.varName, (Object)this.archive, (ShellContextVariableLifecycleHandler)new AbstractShellContextVariableLifecycleHandler(){

            @Override
            public void onRemove(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }

            @Override
            public void onContextDestroyed(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }
        });
        this.print(Messages.i18n.format("OpenArchive.Opened", new Object[]{archiveFile.getCanonicalPath()}), new Object[0]);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) {
        return this.validateArchiveSession();
    }
}

